/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.block.natural.CrimsonHeartBlock;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.worldgen.BannedBiomeMultiNoiseBiomeSource;
import org.confluence.mod.mixed.IMultiNoiseBiomeSource;
import org.joml.Vector3d;

public class CrimsonCaveStructure
extends Structure {
    public static final MapCodec<CrimsonCaveStructure> CODEC = CrimsonCaveStructure.simpleCodec(CrimsonCaveStructure::new);

    public CrimsonCaveStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        Pair<Holder<Biome>, Holder<Biome>> pair;
        BannedBiomeMultiNoiseBiomeSource banned;
        MultiNoiseBiomeSource multi;
        BiomeSource biomeSource = context.chunkGenerator().getBiomeSource();
        if (biomeSource instanceof MultiNoiseBiomeSource && ((multi = (MultiNoiseBiomeSource)biomeSource) instanceof BannedBiomeMultiNoiseBiomeSource ? (banned = (BannedBiomeMultiNoiseBiomeSource)multi).getBannedBiome() == ModBiomes.THE_CRIMSON : (pair = IMultiNoiseBiomeSource.of(multi).confluence$getBiomePair()) != null && pair.getFirst() != null && ((Holder)pair.getFirst()).is(ModBiomes.THE_CRIMSON))) {
            return Optional.empty();
        }
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 && lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return CrimsonCaveStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            Vector3d posPoint;
            WorldgenRandom random = context.random();
            ArrayList<Vector3d> VctList = new ArrayList<Vector3d>();
            int fingerCount = random.nextInt(6, 10);
            int radius = random.nextInt(5, 6);
            int radiusEnd = random.nextInt(15, 18);
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            centerPos = centerPos.offset(0, radius - 1, 0);
            BlockPos endPos = centerPos.offset(random.nextInt(-20, 21), random.nextInt(-65, -60), random.nextInt(-20, 21));
            double layer0 = 5.0;
            double layer1 = radius + 2;
            double xDis = (double)(endPos.getX() - centerPos.getX()) / layer0;
            double yDis = (double)(endPos.getY() - centerPos.getY()) / layer0;
            double zDis = (double)(endPos.getZ() - centerPos.getZ()) / layer0;
            double xStart = centerPos.getX();
            double yStart = centerPos.getY();
            double zStart = centerPos.getZ();
            float rotate = random.nextFloat() * ((float)Math.PI * 2);
            float fingerRotate = random.nextFloat() * ((float)Math.PI * 2);
            float fingerRotateStep = (float)Math.PI * 2 / (float)fingerCount;
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            StructureUtils.ball((int)radius, (int)2, (BlockPos)centerPos, (Object2IntMap)blockMap, (float)0.05f, (WorldgenRandom)random, (int)1, (int)0);
            StructureUtils.ball((int)radiusEnd, (int)4, (BlockPos)endPos, (Object2IntMap)blockMap, (float)0.01f, (WorldgenRandom)random, (int)1, (int)0);
            int i = 0;
            while ((double)i < layer0) {
                posPoint = new Vector3d(i == 0 ? xStart : xStart + (double)i * xDis + (double)random.nextInt(-20, 21), yStart + (double)i * yDis, i == 0 ? zStart : zStart + (double)i * zDis + (double)random.nextInt(-20, 21));
                VctList.add(posPoint);
                ++i;
            }
            VectorUtils.lightningPathList(VctList, (double)1.0, (int)5, (RandomSource)random);
            StructureUtils.lineSet(VctList, (double)4.0, (double)8.0, (int)1, (boolean)false, (Object2IntMap)blockMap);
            StructureUtils.lineSet(VctList, (double)2.0, (double)6.0, (int)0, (boolean)true, (Object2IntMap)blockMap);
            VctList.clear();
            xDis = (double)((float)(radius * 2 + 2) * Mth.cos((float)rotate)) / layer1;
            zDis = (double)((float)(radius * 2 + 2) * Mth.sin((float)rotate)) / layer1;
            i = 0;
            while ((double)i < layer1) {
                posPoint = new Vector3d(xStart + (double)i * xDis, yStart, zStart + (double)i * zDis);
                VctList.add(posPoint);
                ++i;
            }
            StructureUtils.lineSet(VctList, (double)3.0, (double)3.0, (int)0, (boolean)true, (Object2IntMap)blockMap);
            boolean wrappedCrimsonHeart = (Boolean)CommonConfigs.WRAPPED_CRIMSON_HEART.get();
            for (int i2 = 0; i2 < fingerCount; ++i2) {
                VctList.clear();
                VctList.add(new Vector3d((double)endPos.getX() + (3.0 + 1.5 * random.nextDouble()) * (double)radiusEnd * (double)Mth.cos((float)(fingerRotate + (float)i2 * fingerRotateStep)), (double)endPos.getY() + (random.nextDouble() - 0.5) * 4.0 * (double)radiusEnd, (double)endPos.getZ() + (3.0 + 1.5 * random.nextDouble()) * (double)radiusEnd * (double)Mth.sin((float)(fingerRotate + (float)i2 * fingerRotateStep))));
                VctList.add(new Vector3d((double)endPos.getX(), (double)endPos.getY(), (double)endPos.getZ()));
                VectorUtils.lightningPathList(VctList, (double)1.0, (int)5, (RandomSource)random);
                StructureUtils.lineSet(VctList, (double)4.0, (double)8.0, (int)1, (boolean)false, (Object2IntMap)blockMap);
                StructureUtils.lineSet(VctList, (double)2.0, (double)6.0, (int)0, (boolean)true, (Object2IntMap)blockMap);
                BlockPos pos = VectorUtils.fromVector3d((Vector3d)((Vector3d)VctList.getFirst()));
                if (wrappedCrimsonHeart) {
                    StructureUtils.ball((double)4.0, (BlockPos)pos, (int)1, (boolean)true, (Object2IntMap)blockMap);
                    StructureUtils.ball((double)2.0, (BlockPos)pos, (int)0, (boolean)true, (Object2IntMap)blockMap);
                }
                blockMap.put((Object)pos, 2);
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((Block)NatureBlocks.CRIMSTONE.get()).defaultBlockState(), ((CrimsonHeartBlock)((Object)((Object)NatureBlocks.CRIMSON_HEART.get()))).defaultBlockState()}), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.CRIMSON_CAVE.get();
    }
}

