/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.joml.Vector3d;

public class GraniteCaveStructure
extends Structure {
    public static final MapCodec<GraniteCaveStructure> CODEC = GraniteCaveStructure.simpleCodec(GraniteCaveStructure::new);

    public GraniteCaveStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return GraniteCaveStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            BlockPos checkPos;
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(random.nextInt(-20, 21));
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            Vector3d start = new Vector3d((double)(centerPos.getX() + random.nextInt(-3, 4)), (double)(centerPos.getY() + 20), (double)(centerPos.getZ() + random.nextInt(-3, 4)));
            Vector3d end = new Vector3d((double)(centerPos.getX() + random.nextInt(-3, 4)), (double)(centerPos.getY() - 20), (double)(centerPos.getZ() + random.nextInt(-3, 4)));
            int blockstate = 1;
            List listPos = VectorUtils.frustumSetPos((Vector3d)start, (Vector3d)end, (double)((double)random.nextInt(38, 41) + 0.5), (double)((double)random.nextInt(38, 41) + 0.5), (float)2.0E-4f, (WorldgenRandom)random);
            ArrayList listPos1 = new ArrayList();
            ArrayList listPos2 = new ArrayList();
            ArrayList listPos3 = new ArrayList();
            for (Vector3d vector3d : listPos) {
                listPos1.addAll(VectorUtils.ellipsoidPos((double)13.5, (double)9.5, (double)13.5, (BlockPos)VectorUtils.fromVector3d((Vector3d)vector3d), (float)0.002f, (WorldgenRandom)random));
            }
            for (Vector3d vector3d : listPos1) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                listPos2.addAll(VectorUtils.ellipsoidPos((double)11.5, (double)6.5, (double)11.5, (BlockPos)checkPos, (float)0.002f, (WorldgenRandom)random));
            }
            for (Vector3d vector3d : listPos2) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                StructureUtils.ellipsoid((double)9.5, (double)4.5, (double)9.5, (BlockPos)checkPos, (int)blockstate, (boolean)true, (Object2IntMap)blockMap);
            }
            for (Vector3d vector3d : listPos2) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                StructureUtils.ellipsoid((double)((double)random.nextInt(4, 9) + 0.5), (double)2.5, (double)((double)random.nextInt(4, 9) + 0.5), (BlockPos)checkPos, (int)0, (boolean)true, (Object2IntMap)blockMap);
            }
            for (Vector3d vector3d : listPos2) {
                if (!(0.001f > random.nextFloat())) continue;
                listPos3.addAll(VectorUtils.ellipsoidPos((double)((double)random.nextInt(8, 13) + 0.5), (double)1.5, (double)((double)random.nextInt(8, 13) + 0.5), (BlockPos)VectorUtils.fromVector3d((Vector3d)vector3d), (float)0.05f, (WorldgenRandom)random));
            }
            for (Vector3d vector3d : listPos3) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                StructureUtils.ellipsoid((double)((double)random.nextInt(4, 9) + 0.5), (double)0.1, (double)((double)random.nextInt(4, 9) + 0.5), (BlockPos)checkPos, (int)blockstate, (boolean)true, (Object2IntMap)blockMap);
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((Block)NatureBlocks.GRANITE.get()).defaultBlockState(), Blocks.GRANITE.defaultBlockState()}), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.GRANITE_CAVE.get();
    }
}

