/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.worldgen.structure.BaseStructures;

public class LivingTreeStructure
extends Structure {
    public static final MapCodec<LivingTreeStructure> CODEC = LivingTreeStructure.simpleCodec(LivingTreeStructure::new);

    protected LivingTreeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return LivingTreeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            BlockPos centerPos;
            WorldgenRandom random = context.random();
            BlockPos chestPos = centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            centerPos = BaseStructures.livingTree(centerPos, (Object2IntMap<BlockPos>)blockMap, random, random.nextInt(55, 65), 4, 5.9, 1.0, 1, 20, 15, -20, 2, 2, 1, 1, 5, 5, 10, 7, -10, 2, 2, 1, 1, 5, 5, true, random.nextInt(65, 95), 4, 4.9, 1.0, 1, true, 20.0, 10.0, 30.0, 15.0, 4.0, 2.0, 0.01f, 0.75f, 2, 1);
            Rotation rotation = (Rotation)Util.getRandom((Object[])Rotation.values(), (RandomSource)random);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((RotatedPillarBlock)NatureBlocks.LIVING_LOG_BLOCKS.WOOD.get()).defaultBlockState(), (BlockState)((LeavesBlock)NatureBlocks.LIVING_LOG_BLOCKS.LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.TRUE)}), Map.of(chestPos.offset(0, -3, 3), Confluence.asResource("surface_chests")), (StructurePiecesBuilder)builder);
            StructureTemplateManager manager = context.structureTemplateManager();
            switch (rotation) {
                case CLOCKWISE_90: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, "living_room", centerPos.offset(5, 0, 1), true, true, rotation));
                    break;
                }
                case CLOCKWISE_180: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, "living_room", centerPos.offset(-1, 0, 5), true, true, rotation));
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, "living_room", centerPos.offset(-5, 0, -1), true, true, rotation));
                    break;
                }
                default: {
                    builder.addPiece((StructurePiece)new SimpleTemplatePiece(manager, "living_room", centerPos.offset(1, 0, -5), true, true, rotation));
                }
            }
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.LIVING_TREE.get();
    }
}

