/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.joml.Vector3d;

public class MarbleCaveStructure
extends Structure {
    public static final MapCodec<MarbleCaveStructure> CODEC = MarbleCaveStructure.simpleCodec(MarbleCaveStructure::new);
    public static final ResourceKey<ConfiguredFeature<?, ?>> MARBLE_CAVE_POT = Confluence.asResourceKey(Registries.CONFIGURED_FEATURE, "marble_cave_pot");

    public MarbleCaveStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return MarbleCaveStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            BlockPos checkPos;
            WorldgenRandom random = context.random();
            HashMap<BlockPos, ResourceLocation> featureMap = new HashMap<BlockPos, ResourceLocation>();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(random.nextInt(-20, 21));
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            Vector3d start = new Vector3d((double)(centerPos.getX() + random.nextInt(-3, 4)), (double)(centerPos.getY() + 10), (double)(centerPos.getZ() + random.nextInt(-3, 4)));
            Vector3d end = new Vector3d((double)(centerPos.getX() + random.nextInt(-3, 4)), (double)(centerPos.getY() - 10), (double)(centerPos.getZ() + random.nextInt(-3, 4)));
            List listPos = VectorUtils.frustumSetPos((Vector3d)start, (Vector3d)end, (double)((double)random.nextInt(38, 41) + 0.5), (double)((double)random.nextInt(38, 41) + 0.5), (float)2.0E-4f, (WorldgenRandom)random);
            ArrayList listPos1 = new ArrayList();
            ArrayList listPos2 = new ArrayList();
            for (Vector3d vector3d : listPos) {
                listPos1.addAll(VectorUtils.ellipsoidPos((double)13.5, (double)13.5, (double)13.5, (BlockPos)VectorUtils.fromVector3d((Vector3d)vector3d), (float)0.002f, (WorldgenRandom)random));
            }
            for (Vector3d vector3d : listPos1) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                listPos2.addAll(VectorUtils.ellipsoidPos((double)11.5, (double)11.5, (double)11.5, (BlockPos)checkPos, (float)0.002f, (WorldgenRandom)random));
            }
            for (Vector3d vector3d : listPos2) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                StructureUtils.ellipsoid((double)9.5, (double)9.5, (double)9.5, (BlockPos)checkPos, (int)1, (boolean)true, (Object2IntMap)blockMap);
            }
            for (Vector3d vector3d : listPos2) {
                checkPos = VectorUtils.fromVector3d((Vector3d)vector3d);
                StructureUtils.ellipsoid((double)((double)random.nextInt(4, 9) + 0.5), (double)((double)random.nextInt(4, 9) + 0.5), (double)((double)random.nextInt(4, 9) + 0.5), (BlockPos)checkPos, (int)0, (boolean)true, (Object2IntMap)blockMap);
                if (!(0.1f > random.nextFloat())) continue;
                featureMap.put(checkPos, MARBLE_CAVE_POT.location());
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.CALCITE.defaultBlockState()}), featureMap, (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.MARBLE_CAVE.get();
    }
}

