/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class OasisStructure
extends Structure {
    public static final MapCodec<OasisStructure> CODEC = OasisStructure.simpleCodec(OasisStructure::new);

    protected OasisStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int averageY = 0;
        for (int x1 = -1; x1 < 2; ++x1) {
            for (int z1 = -1; z1 < 2; ++z1) {
                averageY += StructureUtils.getHeight((int)(x + 16 * x1), (int)(z + 16 * z1), (Structure.GenerationContext)context);
            }
        }
        int lowestY = averageY /= 9;
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return OasisStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            Vector3d start = new Vector3d((double)(centerPos.getX() + random.nextInt(-2, 3)), (double)(centerPos.getY() - 20), (double)(centerPos.getZ() + random.nextInt(-2, 3)));
            Vector3d end = new Vector3d((double)centerPos.getX(), (double)(centerPos.getY() + 1), (double)centerPos.getZ());
            List listPos = VectorUtils.frustumSetPos((Vector3d)start, (Vector3d)end, (double)60.5, (double)40.5, (float)0.2f, (WorldgenRandom)random);
            HashMap<BlockPos, ResourceLocation> feature = new HashMap<BlockPos, ResourceLocation>();
            for (Vector3d vector3d : listPos) {
                BlockPos checkPos = VectorUtils.fromVector3d((Vector3d)vector3d).offset(0, 4, 0);
                if (checkPos.getY() <= centerPos.getY() || !(0.05f > random.nextFloat())) continue;
                Vector3d vector3d2 = new Vector3d((double)centerPos.getX(), 0.0, (double)centerPos.getZ());
                Vector3d vector3d3 = new Vector3d((double)checkPos.getX(), 0.0, (double)checkPos.getZ());
                if (!(vector3d2.distance((Vector3dc)vector3d3) > 32.0)) continue;
                feature.put(checkPos, Confluence.asResource("palm_tree"));
            }
            StructureUtils.lineSet((List)listPos, (double)3.5, (double)3.5, (int)2, (boolean)true, (Object2IntMap)blockMap);
            List listVct = VectorUtils.ballPos((double)18.5, (BlockPos)centerPos.offset(0, 18, 0), (float)0.02f, (WorldgenRandom)random);
            for (Vector3d vector3d : listVct) {
                StructureUtils.ball((double)15.5, (BlockPos)VectorUtils.fromVector3d((Vector3d)vector3d), (int)0, (int)3, (boolean)true, (Object2IntMap)blockMap, (int)(centerPos.getY() - 1));
            }
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.SAND.defaultBlockState(), ((Block)NatureBlocks.MOISTENED_SAND_BLOCK.get()).defaultBlockState(), Blocks.WATER.defaultBlockState()}), feature, (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.OASIS.get();
    }
}

