/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.common.worldgen.structure.SimpleTemplatePiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.common.block.natural.JungleHiveBlock;
import org.confluence.mod.common.block.natural.ThinHoneyBlock;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;

public class QueenBeeHiveStructure
extends Structure {
    public static final MapCodec<QueenBeeHiveStructure> CODEC = QueenBeeHiveStructure.simpleCodec(QueenBeeHiveStructure::new);

    protected QueenBeeHiveStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 && lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return QueenBeeHiveStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            int radius = random.nextInt(12, 15);
            int radius2 = 2 * radius;
            BlockPos centerPos = startChunk.getMiddleBlockPosition(random.nextInt(-40, 30));
            BlockPos.MutableBlockPos pillarEndPos = centerPos.mutable();
            BlockPos.MutableBlockPos pillarStartPos = centerPos.mutable();
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            double r1 = (double)random.nextInt(360) / 180.0 * Math.PI;
            double r2 = ((double)random.nextInt(30) + 165.0) / 180.0 * Math.PI + r1;
            BlockPos hight1 = new BlockPos(Mth.floor((double)((double)radius * Math.sin(r1))), centerPos.getY(), Mth.floor((double)((double)radius * Math.cos(r1))));
            BlockPos hight2 = new BlockPos(Mth.floor((double)((double)radius * Math.sin(r2))), centerPos.getY(), Mth.floor((double)((double)radius * Math.cos(r2))));
            StructureUtils.ball((int)radius, (int)3, (BlockPos)centerPos, (Object2IntMap)blockMap, (float)0.02f, (WorldgenRandom)random, (int)1, (int)0, (int)3, (int)(centerPos.getY() - radius + 1));
            for (int xPos = -radius2 - 1; xPos <= radius2; ++xPos) {
                for (int zPos = -radius2 - 1; zPos <= radius2; ++zPos) {
                    if ((xPos + zPos * 4) % 15 != 0) continue;
                    double dis1 = 2.0 * ((double)radius - Math.sqrt(Math.pow(xPos - hight1.getX(), 2.0) + Math.pow(zPos - hight1.getZ(), 2.0))) / (double)radius - 1.0;
                    double dis2 = 2.0 * ((double)radius - Math.sqrt(Math.pow(xPos - hight2.getX(), 2.0) + Math.pow(zPos - hight2.getZ(), 2.0))) / (double)radius - 1.0;
                    double uDis1 = (Math.sqrt(Math.abs(dis1)) * dis1 / Math.abs(dis1) + 1.0) * (double)radius * 0.4;
                    double uDis2 = (Math.sqrt(Math.abs(dis2)) * dis2 / Math.abs(dis2) + 1.0) * (double)radius * 0.4;
                    pillarEndPos.set(xPos + centerPos.getX(), centerPos.getY() - radius + (int)uDis1 + (int)uDis2 + random.nextInt(2), zPos + centerPos.getZ());
                    pillarStartPos.set((Vec3i)pillarEndPos.immutable());
                    pillarStartPos.setY(centerPos.getY() - radius2);
                    int block = blockMap.getInt((Object)pillarEndPos.immutable());
                    if (block != 0 && block != 3) continue;
                    StructureUtils.rectangular((BlockPos)pillarStartPos.offset(-2, 0, -1).immutable(), (BlockPos)pillarEndPos.offset(2, 0, 1), (int)1, (Object2IntMap)blockMap, (int)1);
                    StructureUtils.rectangular((BlockPos)pillarStartPos.offset(-1, 0, -2).immutable(), (BlockPos)pillarEndPos.offset(1, 0, -1), (int)1, (Object2IntMap)blockMap, (int)1);
                    StructureUtils.rectangular((BlockPos)pillarStartPos.offset(-1, 0, 1).immutable(), (BlockPos)pillarEndPos.offset(1, 0, 2), (int)1, (Object2IntMap)blockMap, (int)1);
                    float chance = random.nextFloat();
                    if (chance <= 0.5f) {
                        StructureUtils.rectangular((BlockPos)pillarEndPos.offset(-1, 0, -1).immutable(), (BlockPos)pillarEndPos.offset(1, 0, 1).immutable(), (int)0, (Object2IntMap)blockMap, (int)1);
                        continue;
                    }
                    if (chance <= 0.75f) {
                        StructureUtils.rectangular((BlockPos)pillarEndPos.offset(-1, 0, -1).immutable(), (BlockPos)pillarEndPos.offset(1, 0, 1).immutable(), (int)2, (Object2IntMap)blockMap, (int)1);
                        continue;
                    }
                    StructureUtils.rectangular((BlockPos)pillarEndPos.offset(-1, 0, -1).immutable(), (BlockPos)pillarEndPos.offset(1, 0, 1).immutable(), (int)3, (Object2IntMap)blockMap, (int)1);
                }
            }
            StructureUtils.rectangular((BlockPos)centerPos.offset(-2, -radius2, -1).immutable(), (BlockPos)centerPos.offset(2, -1, 1), (int)1, (Object2IntMap)blockMap, (int)1);
            StructureUtils.rectangular((BlockPos)centerPos.offset(-1, -radius2, -2).immutable(), (BlockPos)centerPos.offset(1, -1, -1), (int)1, (Object2IntMap)blockMap, (int)1);
            StructureUtils.rectangular((BlockPos)centerPos.offset(-1, -radius2, 1).immutable(), (BlockPos)centerPos.offset(1, -1, 2), (int)1, (Object2IntMap)blockMap, (int)1);
            StructureUtils.rectangular((BlockPos)centerPos.offset(-1, -1, -1).immutable(), (BlockPos)centerPos.offset(1, 2, 1).immutable(), (int)2, (Object2IntMap)blockMap, (int)1);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), (BlockState)((JungleHiveBlock)((Object)((Object)NatureBlocks.JUNGLE_HIVE_BLOCK.get()))).defaultBlockState().setValue((Property)JungleHiveBlock.NATURAL, (Comparable)Boolean.valueOf(true)), ((ThinHoneyBlock)((Object)((Object)NatureBlocks.THIN_HONEY_BLOCK.get()))).defaultBlockState(), ((LiquidBlock)ModBlocks.HONEY.get()).defaultBlockState()}), (StructurePiecesBuilder)builder);
            builder.addPiece((StructurePiece)new SimpleTemplatePiece(context.structureTemplateManager(), "larva", centerPos, true, true, (Rotation)Util.getRandom((Object[])Rotation.values(), (RandomSource)random)));
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.QUEEN_BEE_HIVE.get();
    }
}

