/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.create.ponder;

import java.util.function.BiConsumer;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.neoforged.fml.ModList;
import org.confluence.mod.integration.create.ponder.ModPonderPlugin;

public class PonderHelper {
    public static final boolean IS_LOADED = ModList.get().isLoaded("ponder");

    public static void registerPlugin() {
        if (IS_LOADED) {
            try {
                PonderIndex.addPlugin((PonderPlugin)((PonderPlugin)ModPonderPlugin.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addTranslateKeys(BiConsumer<String, String> consumer, boolean en) {
        PonderHelper.addTranslateKey("using_altar", consumer, en, "Using Altar", "\u4f7f\u7528\u796d\u575b", new String[]{"Right click with item to store materials", "Right click while sneaking to take materials", "Left click to crafting once", "Left click while sneaking to quick crafting"}, new String[]{"\u624b\u6301\u7269\u54c1\u53f3\u51fb\u4ee5\u5b58\u5165\u6750\u6599", "\u6f5c\u884c\u53f3\u51fb\u4ee5\u53d6\u51fa\u6750\u6599", "\u5de6\u51fb\u4ee5\u5408\u6210\u4e00\u4e2a", "\u6f5c\u884c\u5de6\u51fb\u4ee5\u5feb\u901f\u5408\u6210"});
        PonderHelper.addTranslateKey("connecting", consumer, en, "Connecting", "\u8fde\u63a5", new String[]{"Select first mechanical block", "Select second mechanical block"}, new String[]{"\u9009\u62e9\u7b2c\u4e00\u4e2a\u673a\u68b0\u65b9\u5757", "\u9009\u62e9\u7b2c\u4e8c\u4e2a\u673a\u68b0\u65b9\u5757"});
    }

    private static void addTranslateKey(String sceneId, BiConsumer<String, String> consumer, boolean isEn, String enHeader, String zhHeader, String[] en, String[] zh) {
        if (isEn) {
            consumer.accept("confluence.ponder." + sceneId + ".header", enHeader);
        } else {
            consumer.accept("confluence.ponder." + sceneId + ".header", zhHeader);
        }
        for (int i = 0; i < en.length; ++i) {
            if (isEn) {
                consumer.accept("confluence.ponder." + sceneId + ".text_" + (i + 1), en[i]);
                continue;
            }
            consumer.accept("confluence.ponder." + sceneId + ".text_" + (i + 1), zh[i]);
        }
    }
}

