/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.heaven_destiny_moment.context.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaohunao.heaven_destiny_moment.common.automation.AutomationContext;
import com.xiaohunao.heaven_destiny_moment.common.context.condition.ICondition;
import java.util.Optional;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.attachment.EverBeneficial;

public record EverBeneficialCondition(Optional<Integer> lifeCrystals, Optional<Integer> lifeFruits, Optional<Boolean> vitalCrystal, Optional<Boolean> aegisApple, Optional<Boolean> ambrosia, Optional<Boolean> gummyWorm, Optional<Boolean> galaxyPearl, Optional<Boolean> minecartUpgradeKit, Optional<Boolean> artisanLoafUsed) implements ICondition
{
    public static final MapCodec<EverBeneficialCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("lifeCrystals").forGetter(EverBeneficialCondition::lifeCrystals), (App)Codec.INT.optionalFieldOf("lifeFruits").forGetter(EverBeneficialCondition::lifeFruits), (App)Codec.BOOL.optionalFieldOf("vitalCrystal").forGetter(EverBeneficialCondition::vitalCrystal), (App)Codec.BOOL.optionalFieldOf("aegisApple").forGetter(EverBeneficialCondition::aegisApple), (App)Codec.BOOL.optionalFieldOf("ambrosia").forGetter(EverBeneficialCondition::ambrosia), (App)Codec.BOOL.optionalFieldOf("gummyWorm").forGetter(EverBeneficialCondition::gummyWorm), (App)Codec.BOOL.optionalFieldOf("galaxyPearl").forGetter(EverBeneficialCondition::galaxyPearl), (App)Codec.BOOL.optionalFieldOf("minecartUpgradeKit").forGetter(EverBeneficialCondition::minecartUpgradeKit), (App)Codec.BOOL.optionalFieldOf("artisanLoafUsed").forGetter(EverBeneficialCondition::artisanLoafUsed)).apply((Applicative)instance, EverBeneficialCondition::new));

    public boolean matches(AutomationContext context) {
        if (context.player().isEmpty()) {
            return false;
        }
        Player player = (Player)context.player().get();
        EverBeneficial everBeneficial = EverBeneficial.of((LivingEntity)player);
        if (this.lifeCrystals.isPresent() && everBeneficial.getUsedLifeCrystals() < this.lifeCrystals.get()) {
            return false;
        }
        if (this.lifeFruits.isPresent() && everBeneficial.getUsedLifeFruits() < this.lifeFruits.get()) {
            return false;
        }
        if (this.vitalCrystal.isPresent() && everBeneficial.isVitalCrystalUsed() != this.vitalCrystal.get().booleanValue()) {
            return false;
        }
        if (this.aegisApple.isPresent() && everBeneficial.isAegisAppleUsed() != this.aegisApple.get().booleanValue()) {
            return false;
        }
        if (this.ambrosia.isPresent() && everBeneficial.isAmbrosiaUsed() != this.ambrosia.get().booleanValue()) {
            return false;
        }
        if (this.gummyWorm.isPresent() && everBeneficial.isGummyWormUsed() != this.gummyWorm.get().booleanValue()) {
            return false;
        }
        if (this.galaxyPearl.isPresent() && everBeneficial.isGalaxyPearlUsed() != this.galaxyPearl.get().booleanValue()) {
            return false;
        }
        if (this.minecartUpgradeKit.isPresent() && everBeneficial.isMinecartUpgradeKitUsed() != this.minecartUpgradeKit.get().booleanValue()) {
            return false;
        }
        return !this.artisanLoafUsed.isPresent() || everBeneficial.isArtisanLoafUsed() == this.artisanLoafUsed.get().booleanValue();
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Integer lifeCrystals;
        private Integer lifeFruits;
        private Boolean vitalCrystal;
        private Boolean aegisApple;
        private Boolean ambrosia;
        private Boolean gummyWorm;
        private Boolean galaxyPearl;
        private Boolean minecartUpgradeKit;
        private Boolean artisanLoafUsed;

        public Builder lifeCrystals(Integer value) {
            this.lifeCrystals = value;
            return this;
        }

        public Builder lifeFruits(Integer value) {
            this.lifeFruits = value;
            return this;
        }

        public Builder vitalCrystal(Boolean value) {
            this.vitalCrystal = value;
            return this;
        }

        public Builder aegisApple(Boolean value) {
            this.aegisApple = value;
            return this;
        }

        public Builder ambrosia(Boolean value) {
            this.ambrosia = value;
            return this;
        }

        public Builder gummyWorm(Boolean value) {
            this.gummyWorm = value;
            return this;
        }

        public Builder galaxyPearl(Boolean value) {
            this.galaxyPearl = value;
            return this;
        }

        public Builder minecartUpgradeKit(Boolean value) {
            this.minecartUpgradeKit = value;
            return this;
        }

        public Builder artisanLoafUsed(Boolean value) {
            this.artisanLoafUsed = value;
            return this;
        }

        public EverBeneficialCondition build() {
            return new EverBeneficialCondition(Optional.ofNullable(this.lifeCrystals), Optional.ofNullable(this.lifeFruits), Optional.ofNullable(this.vitalCrystal), Optional.ofNullable(this.aegisApple), Optional.ofNullable(this.ambrosia), Optional.ofNullable(this.gummyWorm), Optional.ofNullable(this.galaxyPearl), Optional.ofNullable(this.minecartUpgradeKit), Optional.ofNullable(this.artisanLoafUsed));
        }
    }
}

