/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.irons_spell;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import org.confluence.mod.api.event.AdditionalManaEvent;
import org.confluence.mod.client.handler.CompatibilityHandler;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.util.PlayerUtils;

public class IronSpellHelper {
    public static final String MODID = "irons_spellbooks";
    public static final boolean IS_LOADED = ModList.get().isLoaded("irons_spellbooks");
    private static final ResourceLocation MANA_OVERLAY_NAME = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"mana_overlay");

    public static float getInitMaxMana() {
        return (float)((Attribute)AttributeRegistry.MAX_MANA.get()).getDefaultValue();
    }

    public static float toConfluence() {
        return 200.0f / IronSpellHelper.getInitMaxMana();
    }

    public static float getMana(float original, Player player) {
        if (((Boolean)CommonConfigs.CONVERT_IRONS_SPELL_MANA.get()).booleanValue()) {
            return ManaStorage.of((LivingEntity)player).getCurrentMana();
        }
        return original;
    }

    public static void extractMana(float manaCost, ServerPlayer player) {
        if (((Boolean)CommonConfigs.CONVERT_IRONS_SPELL_MANA.get()).booleanValue() && manaCost > 0.0f) {
            ManaStorage manaStorage = ManaStorage.of((LivingEntity)player);
            PlayerUtils.extractAndSync(manaStorage, () -> manaCost * IronSpellHelper.toConfluence(), player);
        }
    }

    public static boolean cancelRenderManaOverlay(ResourceLocation name) {
        return IS_LOADED && CompatibilityHandler.isConvertIronsSpellMana() && MANA_OVERLAY_NAME.equals((Object)name);
    }

    public static void additionalMana(AdditionalManaEvent event) {
        if (IS_LOADED && ((Boolean)CommonConfigs.CONVERT_IRONS_SPELL_MANA.get()).booleanValue()) {
            int value = event.getNeoValue();
            double maxMana = event.getEntity().getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
            event.setNeoValue(value + (int)((maxMana - (double)IronSpellHelper.getInitMaxMana()) / (double)IronSpellHelper.toConfluence()));
        }
    }

    public static void updateMana(LivingEntity living, Holder<Attribute> attribute) {
        if (IS_LOADED && ((Boolean)CommonConfigs.CONVERT_IRONS_SPELL_MANA.get()).booleanValue() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            if (attribute == AttributeRegistry.MAX_MANA.getDelegate()) {
                ManaStorage.of((LivingEntity)player).flushAbility(player);
            }
        }
    }
}

