/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jade;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.common.TombstoneBlock;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class TombstoneInfoProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final TombstoneInfoProvider INSTANCE = new TombstoneInfoProvider();
    public static final ResourceLocation UID = Confluence.asResource("jade_tombstone_info");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag compoundTag = blockAccessor.getServerData();
        Tag tag = compoundTag.get("tombInfo");
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            for (Tag tag2 : listTag) {
                StringTag stringTag;
                String info;
                if (!(tag2 instanceof StringTag) || (info = (stringTag = (StringTag)tag2).getAsString()).isEmpty()) continue;
                iTooltip.add((Component)Component.literal((String)info));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof TombstoneBlock.BEntity) {
            TombstoneBlock.BEntity entity = (TombstoneBlock.BEntity)blockEntity;
            SignText signText = entity.getFrontText();
            ListTag listTag = new ListTag();
            for (Component message : signText.getMessages(false)) {
                listTag.add((Object)StringTag.valueOf((String)message.getString()));
            }
            compoundTag.put("tombInfo", (Tag)listTag);
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

