/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.confluence.lib.common.menu.EitherAmountContainerMenu4x;
import org.confluence.lib.common.menu.ToggleAmountResultSlot;
import org.confluence.lib.common.recipe.EitherAmountRecipe4x;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.mod.integration.jei.ModJeiPlugin;
import org.confluence.mod.integration.jei.RecipeTransferPacketC2S;
import org.jetbrains.annotations.Nullable;

public class EitherRecipe4xHelper {
    private final IIngredientManager ingredientManager;

    public EitherRecipe4xHelper(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public static <I extends MenuRecipeInput, R extends EitherAmountRecipe4x<I>, S extends ToggleAmountResultSlot<R>, A extends ContainerLevelAccess, C extends EitherAmountContainerMenu4x<I, R, S, A>> void register(IRecipeTransferRegistration registration, Class<R> recipeClazz, Class<C> containerClazz, @Nullable MenuType<C> menuType, FakeRecipeFactory<I, R> factory, RecipeType<RecipeHolder<R>> recipeType, boolean allowsCraftingTableRecipe) {
        TransferHandler transferHandler = new TransferHandler(registration.getJeiHelpers(), registration.getTransferHelper(), containerClazz, menuType, recipeType);
        registration.addRecipeTransferHandler(transferHandler, recipeType);
        if (allowsCraftingTableRecipe) {
            registration.addUniversalRecipeTransferHandler(new CraftingRecipeTransferHandler(transferHandler, recipeClazz, factory, containerClazz, menuType));
        }
    }

    public static void setEitherRecipe4x(IRecipeLayoutBuilder builder, RecipeHolder<? extends EitherAmountRecipe4x<?>> recipe) {
        ((EitherAmountRecipe4x)recipe.value()).either.ifLeft(shaped -> {
            int width = shaped.width();
            int height = shaped.height();
            boolean symmetrical = shaped.symmetrical;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    if (symmetrical) {
                        ModJeiPlugin.addInput(builder, j * 18 + 6, i * 18 + 5, (Ingredient)shaped.ingredients().get(width - j - 1 + i * width));
                        continue;
                    }
                    ModJeiPlugin.addInput(builder, j * 18 + 6, i * 18 + 5, (Ingredient)shaped.ingredients().get(j + i * width));
                }
            }
        }).ifRight(shapeless -> {
            builder.setShapeless();
            int i = 0;
            int j = 0;
            for (Ingredient ingredient : shapeless) {
                ModJeiPlugin.addInput(builder, j * 18 + 6, i * 18 + 5, ingredient);
                if (++j < 4) continue;
                j = 0;
                ++i;
            }
        });
        builder.addSlot(RecipeIngredientRole.OUTPUT, 117, 33).addItemStack(((EitherAmountRecipe4x)recipe.value()).getResultItem(null));
    }

    public void drawSummary(IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 80.0f, 0.0f);
        for (ImmutableTriple entry : this.summary(recipeSlotsView)) {
            this.ingredientManager.getIngredientRenderer(((ITypedIngredient)entry.getLeft()).getType()).render(guiGraphics, entry.getMiddle());
            guiGraphics.pose().translate(16.0f, 0.0f, 0.0f);
        }
        guiGraphics.pose().popPose();
    }

    private <T> List<ImmutableTriple<ITypedIngredient<T>, T, Integer>> summary(IRecipeSlotsView recipeSlotsView) {
        HashMap pairMap = new HashMap();
        recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).stream().map(IRecipeSlotView::getDisplayedIngredient).filter(Optional::isPresent).map(Optional::get).forEach(typedIngredient -> {
            ITypedIngredient iTypedIngredient = typedIngredient;
            IIngredientHelper helper = this.ingredientManager.getIngredientHelper(iTypedIngredient.getType());
            Optional optional = iTypedIngredient.getItemStack();
            Object ingredient = iTypedIngredient.getIngredient();
            int amount = (int)helper.getAmount(ingredient);
            optional.ifPresent(itemStack -> pairMap.compute(itemStack.getItem(), (k, t) -> {
                int amount1 = t == null ? amount : (int)helper.getAmount(t.getMiddle()) + amount;
                return new ImmutableTriple((Object)iTypedIngredient, helper.copyWithAmount(ingredient, (long)amount1), (Object)amount1);
            }));
        });
        Comparator<ImmutableTriple> comparator = Comparator.comparingInt(ImmutableTriple::getRight);
        return pairMap.values().stream().sorted(comparator.reversed()).toList();
    }

    public static class TransferHandler<I extends MenuRecipeInput, R extends EitherAmountRecipe4x<I>, S extends ToggleAmountResultSlot<R>, A extends ContainerLevelAccess, C extends EitherAmountContainerMenu4x<I, R, S, A>>
    implements IRecipeTransferHandler<C, RecipeHolder<R>> {
        private final IJeiHelpers jeiHelpers;
        private final IRecipeTransferHandlerHelper transferHelper;
        private final Class<C> containerClazz;
        @Nullable
        private final MenuType<C> menuType;
        private final RecipeType<RecipeHolder<R>> recipeType;

        public TransferHandler(IJeiHelpers jeiHelpers, IRecipeTransferHandlerHelper transferHelper, Class<C> containerClazz, @Nullable MenuType<C> menuType, RecipeType<RecipeHolder<R>> recipeType) {
            this.jeiHelpers = jeiHelpers;
            this.transferHelper = transferHelper;
            this.containerClazz = containerClazz;
            this.menuType = menuType;
            this.recipeType = recipeType;
        }

        public Class<C> getContainerClass() {
            return this.containerClazz;
        }

        public Optional<MenuType<C>> getMenuType() {
            return Optional.ofNullable(this.menuType);
        }

        public RecipeType<RecipeHolder<R>> getRecipeType() {
            return this.recipeType;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(C container, RecipeHolder<R> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
            IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
            List<IRecipeSlotView> slotViews = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(view -> !view.isEmpty()).toList();
            IdentityHashMap<IRecipeSlotView, Set> slotUidCache = new IdentityHashMap<IRecipeSlotView, Set>();
            Object2IntOpenHashMap total = new Object2IntOpenHashMap();
            int[] requires = new int[slotViews.size()];
            Arrays.fill(requires, -1);
            for (Slot slot : ((EitherAmountContainerMenu4x)container).slots) {
                if (slot.isFake() || slot.getItem().isEmpty()) continue;
                ItemStack slotItemStack = slot.getItem();
                for (int i = 0; i < slotViews.size(); ++i) {
                    IRecipeSlotView slotView = slotViews.get(i);
                    Object slotItemStackUid = stackHelper.getUidForStack(slotItemStack, UidContext.Ingredient);
                    if (!slotUidCache.computeIfAbsent(slotView, s -> TransferHandler.calculateUids(s, stackHelper)).contains(slotItemStackUid)) continue;
                    total.put(slotItemStackUid, slot.getItem().getCount());
                    requires[i] = slotView.getItemStacks().findAny().map(ItemStack::getCount).orElse(1);
                }
            }
            if (total.isEmpty()) {
                return this.transferHelper.createUserErrorForMissingSlots((Component)Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing"), slotViews);
            }
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            block2: for (int i = 0; i < slotViews.size(); ++i) {
                IRecipeSlotView slotView = slotViews.get(i);
                int require = requires[i];
                if (require < 0) {
                    missing.add(slotView);
                    continue;
                }
                Set objects = slotUidCache.computeIfAbsent(slotView, s -> TransferHandler.calculateUids(s, stackHelper));
                for (Object object : objects) {
                    if (!total.containsKey(object)) continue;
                    if (total.getInt(object) < require) {
                        missing.add(slotView);
                    }
                    total.addTo(object, -require);
                    continue block2;
                }
            }
            if (!missing.isEmpty()) {
                return this.transferHelper.createUserErrorForMissingSlots((Component)Component.translatable((String)"jei.tooltip.error.recipe.transfer.missing"), missing);
            }
            if (doTransfer) {
                PacketDistributor.sendToServer((CustomPacketPayload)new RecipeTransferPacketC2S(recipe.id(), maxTransfer, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return null;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static Set<Object> calculateUids(IRecipeSlotView recipeSlotView, IStackHelper stackhelper) {
            @Nullable List allIngredientsList = recipeSlotView.getAllIngredientsList();
            HashSet<Object> uids = new HashSet<Object>(allIngredientsList.size());
            for (ITypedIngredient typedIngredient : allIngredientsList) {
                ITypedIngredient typedItemStack;
                if (typedIngredient == null || (typedItemStack = typedIngredient.cast((IIngredientType)VanillaTypes.ITEM_STACK)) == null) continue;
                uids.add(stackhelper.getUidForStack(typedItemStack, UidContext.Ingredient));
            }
            return uids;
        }
    }

    public static class CraftingRecipeTransferHandler<I extends MenuRecipeInput, R extends EitherAmountRecipe4x<I>, S extends ToggleAmountResultSlot<R>, A extends ContainerLevelAccess, C extends EitherAmountContainerMenu4x<I, R, S, A>>
    implements IUniversalRecipeTransferHandler<C> {
        private final TransferHandler<I, R, S, A, C> transferHandler;
        private final Class<R> recipeClazz;
        private final FakeRecipeFactory<I, R> factory;
        private final Class<C> containerClazz;
        @Nullable
        private final MenuType<C> menuType;

        public CraftingRecipeTransferHandler(TransferHandler<I, R, S, A, C> heavyRecipeTransferHandler, Class<R> recipeClazz, FakeRecipeFactory<I, R> factory, Class<C> containerClazz, @Nullable MenuType<C> menuType) {
            this.transferHandler = heavyRecipeTransferHandler;
            this.recipeClazz = recipeClazz;
            this.factory = factory;
            this.containerClazz = containerClazz;
            this.menuType = menuType;
        }

        public Class<C> getContainerClass() {
            return this.containerClazz;
        }

        public Optional<MenuType<C>> getMenuType() {
            return Optional.ofNullable(this.menuType);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public IRecipeTransferError transferRecipe(C container, Object o, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
            ResourceLocation id;
            ResourceLocation resourceLocation;
            if (!(o instanceof RecipeHolder)) return this.transferHandler.transferHelper.createInternalError();
            RecipeHolder recipeHolder = (RecipeHolder)o;
            try {
                id = resourceLocation = recipeHolder.id();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ResourceLocation value = resourceLocation = recipeHolder.value();
            @Nullable EitherAmountRecipe4x recipe4x = RecipeTransferPacketC2S.getRecipe4x(this.recipeClazz, value, arg_0 -> this.lambda$transferRecipe$0((Recipe)value, player, arg_0));
            if (recipe4x == null) return this.transferHandler.transferHelper.createInternalError();
            return this.transferHandler.transferRecipe(container, new RecipeHolder(id, (Recipe)recipe4x), recipeSlots, player, maxTransfer, doTransfer);
        }

        private /* synthetic */ EitherAmountRecipe4x lambda$transferRecipe$0(Recipe value, Player player, Either either) {
            return this.factory.create(value.getResultItem((HolderLookup.Provider)player.registryAccess()), (Either<ShapedRecipePattern, NonNullList<Ingredient>>)either);
        }
    }

    @FunctionalInterface
    public static interface FakeRecipeFactory<I extends MenuRecipeInput, R extends EitherAmountRecipe4x<I>> {
        public R create(ItemStack var1, Either<ShapedRecipePattern, NonNullList<Ingredient>> var2);
    }
}

