/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gui.container.EnhanceForgeScreen;
import org.confluence.mod.common.recipe.EnhancedForgeRecipe;
import org.confluence.mod.integration.jei.ModJeiPlugin;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedForgeCategory<R extends EnhancedForgeRecipe>
implements IRecipeCategory<RecipeHolder<R>> {
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/hellforge.png");
    private final IDrawable icon;

    public EnhancedForgeCategory(IJeiHelpers jeiHelpers, ItemStack iconStack) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(iconStack);
    }

    public int getWidth() {
        return 112;
    }

    public int getHeight() {
        return 48;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<R> recipe, IFocusGroup focuses) {
        int i = 0;
        int j = 0;
        for (Ingredient ingredient : ((EnhancedForgeRecipe)recipe.value()).ingredients) {
            ModJeiPlugin.addInput(builder, 4 + i * 18, 7 + j * 18, ingredient);
            if (i == 1) {
                ++j;
                i = 0;
                continue;
            }
            ++i;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 85, 16).addItemStack(((EnhancedForgeRecipe)recipe.value()).getResultItem(null));
    }

    public void draw(RecipeHolder<R> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 112, 48, 112, 48);
        if (((EnhancedForgeRecipe)recipe.value()).isRequiresFuel()) {
            guiGraphics.blit(EnhanceForgeScreen.SUPER_LIT_PROGRESS, 54, 25, 0.0f, 0.0f, 14, 14, 14, 14);
            if (mouseX >= 54.0 && mouseX <= 68.0 && mouseY >= 25.0 && mouseY <= 39.0) {
                MutableComponent text = Component.translatable((String)"condition.confluence.requires_fuel").withColor(ModRarity.CYAN.color());
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)text, (int)mouseX, (int)mouseY);
            }
        }
    }
}

