/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.recipe.ItemTransmutationRecipe;
import org.confluence.mod.integration.jei.ModJeiPlugin;

public class ShimmerItemTransmutationCategory
implements IRecipeCategory<RecipeHolder<ItemTransmutationRecipe>> {
    public static final RecipeType<RecipeHolder<ItemTransmutationRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("item_transmutation"));
    private final IDrawable icon;

    public ShimmerItemTransmutationCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)ToolItems.BOTTOMLESS_SHIMMER_BUCKET.get()));
    }

    public RecipeType<RecipeHolder<ItemTransmutationRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.shimmer_transmutation");
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 128;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ItemTransmutationRecipe> recipe, IFocusGroup focuses) {
        ItemTransmutationRecipe value = (ItemTransmutationRecipe)recipe.value();
        ItemStack[] items = value.source().getItems();
        IRecipeSlotBuilder inputSlot = builder.addSlot(RecipeIngredientRole.INPUT, 56, 16);
        if (items.length > 1) {
            inputSlot.addIngredients(value.source());
        } else {
            ItemStack input = items.length == 0 ? new ItemStack((ItemLike)Items.BARRIER) : items[0].copy();
            input.setCount(value.shrink());
            inputSlot.addItemStack(input);
        }
        if (value.isValid()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 56, 88).addItemStacks(value.target());
        } else {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 56, 88).addItemStack(Items.BARRIER.getDefaultInstance());
        }
    }

    public void draw(RecipeHolder<ItemTransmutationRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GamePhase gamePhase = ((ItemTransmutationRecipe)recipe.value()).gamePhase();
        if (gamePhase.isAboveThan(KillBoard.INSTANCE.getGamePhase())) {
            ModJeiPlugin.drawArrowDown(guiGraphics, 54, 46, false);
            if (mouseX >= 54.0 && mouseX <= 75.0 && mouseY >= 46.0 && mouseY <= 74.0) {
                MutableComponent text = Component.translatable((String)("condition.confluence.shimmer_transmutation." + gamePhase.getSerializedName())).withStyle(style -> style.withColor(ChatFormatting.RED));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)text, (int)mouseX, (int)mouseY);
            }
        } else {
            ModJeiPlugin.drawArrowDown(guiGraphics, 54, 46, ((ItemTransmutationRecipe)recipe.value()).isValid());
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<ItemTransmutationRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (!((ItemTransmutationRecipe)recipe.value()).isValid()) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.jei.shimmer_black_list").withStyle(ChatFormatting.RED));
        }
    }
}

