/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.mine_team;

import com.google.common.collect.Maps;
import com.xiaohunao.mine_team.MineTeam;
import com.xiaohunao.mine_team.common.attachment.TeamAttachment;
import com.xiaohunao.mine_team.common.network.TeamAttachmentSyncPayload;
import com.xiaohunao.mine_team.common.team.Team;
import com.xiaohunao.mine_team.common.team.TeamManager;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import org.confluence.mod.client.gui.container.ExtraInventoryScreen;

public class ExtraTeamRender {
    private final ExtraInventoryScreen screen;
    private final Map<String, ImageButton> teamSmallIcons = Maps.newHashMap();
    private ImageButton teamIcon;
    private ImageButton teamPVPOn;
    private ImageButton teamPVPOff;

    public ExtraTeamRender(ExtraInventoryScreen screen) {
        this.screen = screen;
    }

    public void renderTeamIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.teamIcon == null || this.teamPVPOff == null || this.teamPVPOn == null || this.teamSmallIcons.isEmpty()) {
            return;
        }
        this.teamIcon.render(guiGraphics, mouseX, mouseY, partialTick);
        this.teamPVPOff.render(guiGraphics, mouseX, mouseY, partialTick);
        this.teamPVPOn.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTeamSmallIcon(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderTeamSmallIcon(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (ImageButton button : this.teamSmallIcons.values()) {
            button.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void initButton() {
        TeamAttachment teamAttachment;
        Team team;
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        TeamManager teamManager = TeamManager.of((Level)localPlayer.level());
        DyeColor dyeColor = teamManager.getDyeColor(team = teamManager.getTeam((teamAttachment = TeamAttachment.of((Entity)localPlayer)).getTeamUid()));
        if (dyeColor != null) {
            String teamColor = dyeColor.getName();
            int iconSize = 16;
            int topOff = 6;
            int leftOff = 193;
            this.teamIcon = new ImageButton(this.screen.getGuiLeft() - iconSize + leftOff, this.screen.getGuiTop(), iconSize, iconSize, ExtraTeamRender.createWidgetSprites("team/" + teamColor + "_team_icon"), button -> {
                this.teamIcon.visible = false;
                this.teamPVPOn.visible = false;
                this.teamPVPOff.visible = false;
                this.visibleTeamSmallIcon(true);
            });
            this.teamPVPOff = new ImageButton(this.screen.getGuiLeft() - iconSize + leftOff, this.screen.getGuiTop() + iconSize + topOff, iconSize, iconSize, ExtraTeamRender.createWidgetSprites("team/pvp/" + teamColor + "_pvp_off"), button -> this.setTeamPvP(localPlayer, true));
            this.teamPVPOn = new ImageButton(this.screen.getGuiLeft() - iconSize + leftOff, this.screen.getGuiTop() + iconSize + topOff, iconSize, iconSize, ExtraTeamRender.createWidgetSprites("team/pvp/" + teamColor + "_pvp_on"), button -> this.setTeamPvP(localPlayer, false));
            this.initSmallIcon(localPlayer);
            this.hasEnableTeamPvP(localPlayer);
            this.addRenderableWidget();
        }
    }

    private void initSmallIcon(LocalPlayer localPlayer) {
        SequencedCollection teamColors = Arrays.stream(DyeColor.values()).map(DyeColor::getName).toList().reversed();
        int size = 8;
        for (int i = 0; i < teamColors.size(); ++i) {
            String newTeamColor = (String)teamColors.get(i);
            int x = this.screen.getGuiLeft() - size - i / 8 * size - i / 8 * 2 + 193;
            int y = this.screen.getGuiTop() + i % 8 * size + i % 8 * 2;
            ImageButton teamSmallIconBtn = new ImageButton(x, y, size, size, ExtraTeamRender.createWidgetSprites("team/small/" + newTeamColor + "_team_small_icon"), button -> this.teamSmallIconButtonPressed(localPlayer, newTeamColor));
            teamSmallIconBtn.visible = false;
            this.teamSmallIcons.put(newTeamColor, teamSmallIconBtn);
        }
    }

    public void addRenderableWidget() {
        this.screen.addRenderableWidget(this.teamIcon);
        this.screen.addRenderableWidget(this.teamPVPOn);
        this.screen.addRenderableWidget(this.teamPVPOff);
        for (ImageButton button : this.teamSmallIcons.values()) {
            this.screen.addRenderableWidget(button);
        }
    }

    private void teamSmallIconButtonPressed(LocalPlayer localPlayer, String teamColor) {
        this.setTeamColor(localPlayer, teamColor);
        this.teamIcon.visible = true;
        this.visibleTeamSmallIcon(false);
        this.hasEnableTeamPvP(localPlayer);
    }

    private void setTeamColor(LocalPlayer localPlayer, String teamColor) {
        TeamAttachment.of((Entity)localPlayer).setTeamUid(TeamManager.of((Level)localPlayer.clientLevel).getTeam(DyeColor.valueOf((String)teamColor.toUpperCase(Locale.ROOT))).getUid());
        TeamAttachmentSyncPayload.sendToServer((Entity)localPlayer);
        ExtraTeamRender.setImageButtonSprites(this.teamIcon, "team/" + teamColor + "_team_icon");
        ExtraTeamRender.setImageButtonSprites(this.teamPVPOn, "team/pvp/" + teamColor + "_pvp_on");
        ExtraTeamRender.setImageButtonSprites(this.teamPVPOff, "team/pvp/" + teamColor + "_pvp_off");
    }

    public void setTeamPvP(LocalPlayer localPlayer, boolean friendlyFire) {
        TeamAttachment.of((Entity)localPlayer).setCanPvP(friendlyFire);
        TeamAttachmentSyncPayload.sendToServer((Entity)localPlayer);
        this.teamPVPOn.visible = friendlyFire;
        this.teamPVPOff.visible = !friendlyFire;
    }

    private void hasEnableTeamPvP(LocalPlayer localPlayer) {
        boolean teamPvP;
        this.teamPVPOn.visible = teamPvP = TeamAttachment.of((Entity)localPlayer).isCanPvP();
        this.teamPVPOff.visible = !teamPvP;
    }

    private void visibleTeamSmallIcon(boolean visible) {
        for (ImageButton button : this.teamSmallIcons.values()) {
            button.visible = visible;
        }
    }

    private static void setImageButtonSprites(ImageButton button, String path) {
        button.sprites = ExtraTeamRender.createWidgetSprites(path);
    }

    private static WidgetSprites createWidgetSprites(String path) {
        return new WidgetSprites(MineTeam.asResource((String)path), MineTeam.asResource((String)path));
    }
}

