/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.sodium.dynamiclights;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.common.init.item.ToolItems;

public class SodiumDynamicLightsHelper {
    public static final boolean IS_LOADED = ModList.get().isLoaded("sodiumdynamiclights");

    public static void registerDynamicLight() {
        if (IS_LOADED) {
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.ARROW_PROJECTILE.get()), entity -> entity.modify.getLuminance());
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.CURSED_FLAMES_PROJECTILE.get()), entity -> 15);
            DynamicLightHandlers.registerDynamicLightHandler((EntityType)((EntityType)ModEntities.STAR_CANNON_BULLET.get()), entity -> 10);
        }
    }

    public static int getLuminance(Entity entity, int returnValue) {
        int luminance = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.getItemBySlot(EquipmentSlot.HEAD).is(ArmorItems.MINING_HELMET)) {
                luminance += 10;
            }
            if (living.hasEffect(ModEffects.SHINE)) {
                luminance += 10;
            }
            if (LibUtils.anyHandHasItem((LivingEntity)living, (Item)((Item)ToolItems.BOTTOMLESS_LAVA_BUCKET.get()))) {
                luminance += 10;
            }
        }
        return returnValue >= 0 ? Math.min(returnValue + luminance, 15) : Math.max(returnValue - luminance, -15);
    }
}

