/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.init;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.mod.common.entity.projectile.sword.BeeKeeperProjectile;
import org.confluence.mod.common.entity.projectile.sword.LightBaneProjectile;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.registries.TERegistries;
import org.confluence.terraentity.registries.hit_effect.EffectStrategy;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.confluence.terraentity.registries.hit_effect.variant.TimePossibilityAmplifierEffect;

public final class ModEffectStrategies {
    public static final DeferredRegister<EffectStrategy> EFFECT_STRATEGY = DeferredRegister.create((Registry)TERegistries.EFFECT_STRATEGIES, (String)"confluence");
    private static final DeferredHolder<EffectStrategy, EffectStrategy> UNDEFINED = ModEffectStrategies.createEffect("undefined", EffectStrategy.UNDEFINED_EFFECT);
    private static final DeferredHolder<EffectStrategy, EffectStrategy> BAT_FANG_EFFECT = ModEffectStrategies.createEffect("bat", (LivingEntity owner, LivingEntity entity) -> owner.heal(1.0f));
    private static final DeferredHolder<EffectStrategy, EffectStrategy> LIGHTS_BANE_EFFECT = ModEffectStrategies.createEffect("lights_bane", (BiConsumer)EffectStrategy.ON_HIT_PROJECTILE.apply(level -> ((LightBaneProjectile)((EntityType)ModEntities.LIGHTS_BANE_PROJECTILE.get()).create(level)).addAttackDamage(7.0f)));
    private static final DeferredHolder<EffectStrategy, EffectStrategy> BEE_KEEPER_EFFECT = ModEffectStrategies.createEffect("bee_keeper", (BiConsumer)EffectStrategy.ON_HIT_PROJECTILE_COUNT.apply(level -> ((BeeKeeperProjectile)((EntityType)ModEntities.BEE_PROJECTILE.get()).create(level)).addAttackDamage(2.0f), 3));

    public static DeferredHolder<EffectStrategy, EffectStrategy> createEffect(String name, BiConsumer<LivingEntity, LivingEntity> effect) {
        return EFFECT_STRATEGY.register(name, () -> new EffectStrategy(name, effect));
    }

    public static DeferredHolder<EffectStrategy, EffectStrategy> createEffect(String name, IEffectStrategy effect) {
        return EFFECT_STRATEGY.register(name, () -> new EffectStrategy(effect));
    }

    public static class Components {
        public static final Supplier<EffectStrategyComponent> TENTACLE_SPIKES_EFFECT = () -> EffectStrategyComponent.of((IEffectStrategy)TimePossibilityAmplifierEffect.of((String)"tentacle_spikes", ModEffects.TENTACLE_SPIKES, (int)180, (int)0, (int)4, (float)0.5f));
        public static final Supplier<EffectStrategyComponent> BLOOD_BUTCHERED_EFFECT = () -> EffectStrategyComponent.of((IEffectStrategy)TimePossibilityAmplifierEffect.of((String)"blood_butchered", (Holder)ModEffects.BLOOD_BUTCHERED.getDelegate(), (int)180, (int)0, (int)4, (float)0.5f));
        public static final Supplier<EffectStrategyComponent> BAT_FANG_EFFECT = () -> EffectStrategyComponent.ofPrefab((String)"bat", BAT_FANG_EFFECT);
        public static final Supplier<EffectStrategyComponent> LIGHTS_BANE_EFFECT = () -> EffectStrategyComponent.ofPrefab((String)"lights_bane", LIGHTS_BANE_EFFECT);
        public static final Supplier<EffectStrategyComponent> BEE_KEEPER_EFFECT = () -> EffectStrategyComponent.ofPrefab((String)"bee_keeper", BEE_KEEPER_EFFECT);
    }
}

