/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terraentity.api.npc.trade.ITrade;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.client.gui.container.TETradeScreen;
import org.confluence.terraentity.entity.npc.mood.NPCMood;
import org.jetbrains.annotations.Nullable;

public interface IMoneyTrade
extends ITrade {
    public long cost();

    default public long getCost(@Nullable Player player, ITradeHolder npc) {
        float discount = 1.0f;
        NPCMood mood = npc.getMood();
        if (mood != null) {
            discount = 100.0f / (float)mood.getValue();
        }
        return (long)((float)this.cost() * discount);
    }

    default public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return PlayerUtils.getMoney(player, true) >= this.getCost(player, npc);
    }

    default public void onTrade(ServerPlayer player, ITradeHolder npc, int index) {
        long cost = this.getCost((Player)player, npc);
        if (PlayerUtils.tryCostMoney((Player)player, cost, true)) {
            this.onTradeSuccess(player, npc, index, cost);
        }
    }

    public void onTradeSuccess(ServerPlayer var1, ITradeHolder var2, int var3, long var4);

    @OnlyIn(value=Dist.CLIENT)
    default public void renderCosts(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY) {
        guiGraphics.blit(TETradeScreen.MENU_LOCATION, startx + 113, starty + 16, 434.0f, 59.0f, 78, 57, 512, 256);
        LocalPlayer player = Minecraft.getInstance().player;
        Coins myCoins = player == null ? null : PlayerUtils.getCoins((Player)player, true);
        x = startx + 5;
        y = starty - 20;
        if (myCoins != null) {
            for (Object2IntMap.Entry entry : myCoins.platinum2CopperEntries()) {
                ItemStack stack = new ItemStack((ItemLike)entry.getKey(), entry.getIntValue());
                int count = stack.getCount();
                guiGraphics.renderItem(stack, x, y);
                float scale = count < 1000 ? 1.0f : 0.75f;
                int moveX = count < 1000 ? 0 : 6;
                int moveY = count < 1000 ? 0 : 5;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(scale, scale, 1.0f);
                guiGraphics.renderItemDecorations(font, stack, (int)((float)x / scale) + moveX, (int)((float)y / scale) + moveY);
                guiGraphics.pose().popPose();
                x += count == 0 ? 0 : 20;
            }
        }
        Coins coins = PlayerUtils.decodeCoin(this.getCost((Player)player, npc));
        x = startx + 165;
        y = starty + 6 + 39;
        int index = -1;
        int i = 0;
        for (Integer coin : coins.copper2Platinum()) {
            String s = coin.toString();
            guiGraphics.drawString(font, s, x + 4 - s.length() * 3, y + 16, Color.orange.getRGB(), true);
            y -= 13;
            if (coin >= 1) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            int w = 34;
            int sx = 443 + ((index & 1) == 0 ? 0 : 35);
            int sy = 118 + ((index & 0xA) == 0 ? 0 : 35);
            guiGraphics.blit(TETradeScreen.MENU_LOCATION, startx + 117, starty + 28, (float)sx, (float)sy, w, w, 512, 256);
        }
    }

    default public List<Ingredient> normalizeCost() {
        return PlayerUtils.decodeCoin(this.cost()).copper2PlatinumEntries().stream().filter(entry -> entry.getIntValue() > 0).map(entry -> AmountIngredient.of((int)entry.getIntValue(), (ItemLike[])new ItemLike[]{(ItemLike)entry.getKey()})).toList();
    }
}

