/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.integration.terra_entity.init.ModTradeProviders;
import org.confluence.mod.integration.terra_entity.npc_trade.IMoneyTrade;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.api.npc.trade.ITradeHealth;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.init.entity.TEBossEntities;
import org.confluence.terraentity.registries.npc_trade.TradeProperties;
import org.confluence.terraentity.registries.npc_trade.TradeProvider;
import org.jetbrains.annotations.Nullable;

public record MoneyTradeHealthFull(@Nullable TradeProperties properties) implements IMoneyTrade,
ITradeHealth
{
    public static final MapCodec<MoneyTradeHealthFull> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TradeProperties.CODEC.optionalFieldOf("properties").forGetter(i -> Optional.ofNullable(i.properties))).apply((Applicative)instance, properties -> new MoneyTradeHealthFull(properties.orElse(null))));

    public static MoneyTradeHealthFull create() {
        return new MoneyTradeHealthFull(null);
    }

    public static MoneyTradeHealthFull create(TradeProperties properties) {
        return new MoneyTradeHealthFull(properties);
    }

    @Override
    public long getCost(@Nullable Player player, ITradeHolder holder) {
        KillBoard instance;
        if (player == null) {
            return 0L;
        }
        long cost = (long)(player.getMaxHealth() - player.getHealth() + 1.0f) * 5L;
        for (MobEffectInstance instance2 : player.getActiveEffects()) {
            if (!ModUtils.isDebuff(instance2)) continue;
            cost += 500L;
        }
        if (LibUtils.isAtLeastExpert((Level)player.level(), (BlockPos)player.blockPosition())) {
            cost *= 2L;
        }
        if ((instance = KillBoard.INSTANCE).getGamePhase().isHardmode()) {
            cost *= 60L;
        } else if (instance.isAnyDefeated((EntityType)TEBossEntities.SKELETRON.get(), (EntityType)TEBossEntities.QUEEN_BEE.get())) {
            cost *= 25L;
        } else if (instance.isAnyDefeated((EntityType)TEBossEntities.EATER_OF_WORLDS.get(), (EntityType)TEBossEntities.BRAIN_OF_CTHULHU.get())) {
            cost *= 10L;
        } else if (instance.isDefeated((EntityType)TEBossEntities.EYE_OF_CTHULHU.get())) {
            cost *= 3L;
        }
        return cost;
    }

    public int getHealth(@Nullable Player player) {
        if (player == null) {
            return this.health();
        }
        return (int)(player.getMaxHealth() - player.getHealth() + 1.0f);
    }

    @Override
    public long cost() {
        return 0L;
    }

    public int health() {
        return 0;
    }

    @Override
    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return IMoneyTrade.super.canTrade(player, npc, index) && super.canTrade(player, npc, index);
    }

    @Override
    public void onTrade(ServerPlayer player, ITradeHolder npc, int index) {
        IMoneyTrade.super.onTrade(player, npc, 0);
    }

    public void renderResultHover(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY) {
    }

    @Override
    public void onTradeSuccess(ServerPlayer player, ITradeHolder npc, int index, long cost) {
        player.setHealth(player.getMaxHealth());
        for (MobEffectInstance instance : ImmutableList.copyOf((Collection)player.getActiveEffects())) {
            if (!ModUtils.isDebuff(instance)) continue;
            player.removeEffect(instance.getEffect());
        }
        AchievementUtils.theFrequentFlyer(player, cost);
    }

    public TradeProvider getCodec() {
        return ModTradeProviders.MONEY_TRADE_HEALTH_FULL.get();
    }
}

