/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.ValueComponent;
import org.confluence.mod.common.item.common.CoinItem;
import org.confluence.mod.common.menu.NPCTradesForgeMenu;
import org.confluence.mod.integration.terra_entity.init.ModTradeProviders;
import org.confluence.mod.network.c2s.SellTradePacketC2S;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.terraentity.api.npc.trade.ITrade;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.client.gui.container.TETradeScreen;
import org.confluence.terraentity.entity.npc.mood.NPCMood;
import org.confluence.terraentity.menu.TETradesMenu;
import org.confluence.terraentity.registries.npc_trade.TradeProperties;
import org.confluence.terraentity.registries.npc_trade.TradeProvider;
import org.jetbrains.annotations.Nullable;

public class SellTrade
implements ITrade {
    public static final SellTrade INSTANCE = new SellTrade();
    public static final MapCodec<SellTrade> CODEC = Codec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit((Object)INSTANCE));

    private SellTrade() {
    }

    public long getCost(@Nullable Player player, ITradeHolder npc, ItemStack stack) {
        if (stack.isEmpty()) {
            return 0L;
        }
        float discount = 1.0f;
        NPCMood mood = npc.getMood();
        if (mood != null) {
            discount = (float)mood.getValue() / 100.0f;
        }
        return (long)((float)ValueComponent.getValue(stack, 0) * discount);
    }

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return true;
    }

    public void onTrade(ServerPlayer player, ITradeHolder npc, int index) {
    }

    public List<ITrade> getAllSupportedTrades() {
        return List.of();
    }

    public List<Ingredient> normalizeCost() {
        return List.of();
    }

    public List<ItemStack> normalizeResult() {
        return List.of();
    }

    public void onSell(ServerPlayer player, ITradeHolder npc, int index) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof NPCTradesForgeMenu) {
            NPCTradesForgeMenu menu = (NPCTradesForgeMenu)abstractContainerMenu;
            ItemStack stack = index > 1000 ? ((Slot)menu.slots.get(index - 1000)).getItem() : ((Slot)menu.slots.getFirst()).getItem();
            Coins coins = PlayerUtils.decodeCoin(ValueComponent.getValue(stack, 0));
            for (Object2IntMap.Entry entry : coins.copper2PlatinumEntries()) {
                player.getInventory().add(new ItemStack((ItemLike)entry.getKey(), entry.getIntValue()));
            }
            stack.setCount(0);
        }
    }

    @Nullable
    public TradeProperties properties() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderCosts(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY) {
        Screen entry2;
        guiGraphics.blit(TETradeScreen.MENU_LOCATION, startx + 113, starty + 16, 434.0f, 59.0f, 78, 57, 512, 256);
        LocalPlayer player = Minecraft.getInstance().player;
        Coins myCoins = player == null ? null : PlayerUtils.getCoins((Player)player, true);
        x = startx + 5;
        y = starty - 20;
        if (myCoins != null) {
            for (Screen entry2 : myCoins.platinum2CopperEntries()) {
                ItemStack stack = new ItemStack((ItemLike)entry2.getKey(), entry2.getIntValue());
                int count = stack.getCount();
                guiGraphics.renderItem(stack, x, y);
                float scale = count < 1000 ? 1.0f : 0.75f;
                int moveX = count < 1000 ? 0 : 6;
                int moveY = count < 1000 ? 0 : 5;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().scale(scale, scale, 1.0f);
                guiGraphics.renderItemDecorations(font, stack, (int)((float)x / scale) + moveX, (int)((float)y / scale) + moveY);
                guiGraphics.pose().popPose();
                x += count == 0 ? 0 : 20;
            }
        }
        if ((entry2 = Minecraft.getInstance().screen) instanceof TETradeScreen) {
            TETradeScreen screen = (TETradeScreen)entry2;
            Coins coins = PlayerUtils.decodeCoin(this.getCost((Player)player, npc, ((Slot)((TETradesMenu)screen.getMenu()).slots.getFirst()).getItem()));
            x = startx + 165;
            y = starty + 6 + 39;
            int index = -1;
            int i = 0;
            for (Integer coin : coins.copper2Platinum()) {
                String s = coin.toString();
                guiGraphics.drawString(font, s, x + 4 - s.length() * 3, y + 16, Color.orange.getRGB(), true);
                y -= 13;
                if (coin >= 1) {
                    index = i;
                }
                ++i;
            }
            if (index >= 0) {
                int w = 34;
                int sx = 443 + ((index & 1) == 0 ? 0 : 35);
                int sy = 118 + ((index & 0xA) == 0 ? 0 : 35);
                guiGraphics.blit(TETradeScreen.MENU_LOCATION, startx + 117, starty + 28, (float)sx, (float)sy, w, w, 512, 256);
                int leftPos = screen.getGuiLeft();
                int topPos = screen.getGuiTop();
                if (mouseX - leftPos >= 127 && (double)(mouseX - leftPos) <= 143.5 && (double)(mouseY - topPos) >= 40.5 && (double)(mouseY - topPos) <= 50.5) {
                    guiGraphics.fillGradient(RenderType.guiOverlay(), leftPos + 126, topPos + 39, leftPos + 143, topPos + 53, -2139062272, -2130706433, 0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderResult(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY, int slotIndex) {
        int size = 4;
        int i = (int)(npc.level().getDayTime() / 40L % (long)size);
        CoinItem it = PlayerUtils.INDEX_2_COIN.apply(i);
        guiGraphics.renderItem(it.getDefaultInstance(), x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderResultHover(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderResultSlot(ITradeHolder npc, GuiGraphics guiGraphics, Font font, int x, int y, int startx, int starty, int mouseX, int mouseY, boolean canBuy, Slot slot) {
        guiGraphics.fill(x, y, x + 23, y + 17, -3750202);
        guiGraphics.blitSprite(Confluence.asResource("widget/arrow_left"), x, y, 22, 17);
    }

    public void onClick(double mouseX, double mouseY, int button, int index, Slot slot) {
        if (slot.hasItem() || index > 1000) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SellTradePacketC2S(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public TradeProvider getCodec() {
        return ModTradeProviders.SELL_TRADE.get();
    }
}

