/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record EnvironmentLock(EnvironmentLevelAccess.Matcher environment) implements ITradeLock
{
    public static final MapCodec<EnvironmentLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnvironmentLevelAccess.Matcher.MAP_CODEC.forGetter(EnvironmentLock::environment)).apply((Applicative)instance, EnvironmentLock::new));

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        return this.environment.matches(new EnvironmentLevelAccess(npc.level(), npc.blockPosition()));
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.ENVIRONMENT_LOCK.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        EnvironmentLevelAccess.Matcher environment1;
        if (o == this) return true;
        if (!(o instanceof EnvironmentLock)) return false;
        EnvironmentLock environmentLock = (EnvironmentLock)o;
        try {
            EnvironmentLevelAccess.Matcher matcher;
            environment1 = matcher = environmentLock.environment();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!Objects.equals(this.environment, environment1)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.environment.hashCode();
    }
}

