/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record FishingHookInFluidLock(List<TagKey<Fluid>> tags, boolean requiresFishingHook) implements ITradeLock
{
    public static final MapCodec<FishingHookInFluidLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.FLUID).listOf().lenientOptionalFieldOf("tags", List.of()).forGetter(FishingHookInFluidLock::tags), (App)Codec.BOOL.lenientOptionalFieldOf("requires_fishing_hook", (Object)true).forGetter(FishingHookInFluidLock::requiresFishingHook)).apply((Applicative)instance, FishingHookInFluidLock::new));

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        FishingHook fishingHook = player.fishing;
        if (fishingHook == null) {
            return !this.requiresFishingHook;
        }
        FluidState fluidState = fishingHook.getInBlockState().getFluidState();
        return this.tags.stream().anyMatch(arg_0 -> ((FluidState)fluidState).is(arg_0));
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.FISHING_HOOK_IN_FLUID_LOCK.get();
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block5: {
            block3: {
                block4: {
                    boolean bl2;
                    List<TagKey<Fluid>> tags1;
                    if (o == this) break block4;
                    if (!(o instanceof FishingHookInFluidLock)) break block3;
                    FishingHookInFluidLock fishingHookInFluidLock = (FishingHookInFluidLock)o;
                    try {
                        List<TagKey<Fluid>> list;
                        tags1 = list = fishingHookInFluidLock.tags();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    boolean requiresFishingHook1 = bl2 = fishingHookInFluidLock.requiresFishingHook();
                    if (this.requiresFishingHook != requiresFishingHook1 || !this.tags.equals(tags1)) break block3;
                }
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.tags);
    }

    @SafeVarargs
    public static FishingHookInFluidLock of(boolean requiresFishingHook, TagKey<Fluid> ... tags) {
        return new FishingHookInFluidLock(Arrays.stream(tags).toList(), requiresFishingHook);
    }
}

