/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade_lock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.data.saved.MoonPhase;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade_lock.TradeLockProvider;

public record MoonPhaseLock(List<MoonPhase> moonPhases) implements ITradeLock
{
    public static final MapCodec<MoonPhaseLock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)ExtraCodecs.nonEmptyList((Codec)MoonPhase.CODEC.listOf()), MoonPhase.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), moonPhases -> moonPhases.size() == 1 ? Either.right((Object)((Object)((MoonPhase)((Object)((Object)((Object)moonPhases.getFirst())))))) : Either.left((Object)moonPhases)).fieldOf("moon_phases").forGetter(MoonPhaseLock::moonPhases)).apply((Applicative)instance, MoonPhaseLock::new));

    public MoonPhaseLock(MoonPhase ... moonPhases) {
        this(Arrays.stream(moonPhases).toList());
    }

    public boolean canTrade(Player player, ITradeHolder npc, int index) {
        int phase = npc.level().getMoonPhase();
        return this.moonPhases.stream().anyMatch(moonPhase -> moonPhase.match(phase));
    }

    public TradeLockProvider getCodec() {
        return ModTradeLockProviderTypes.MOON_PHASE_LOCK.get();
    }
}

