/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.waystones;

import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.integration.waystones.WaystonesHelper;
import org.jetbrains.annotations.NotNull;

public record PlayerToPylonPacketC2S(UUID uuid) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PlayerToPylonPacketC2S> TYPE = new CustomPacketPayload.Type(Confluence.asResource("player_to_pylon"));
    public static final StreamCodec<? super FriendlyByteBuf, PlayerToPylonPacketC2S> STREAM_CODEC = LibStreamCodecUtils.UUID.map(PlayerToPylonPacketC2S::new, PlayerToPylonPacketC2S::uuid);

    @NotNull
    public CustomPacketPayload.Type<PlayerToPylonPacketC2S> type() {
        return TYPE;
    }

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                if (((Boolean)CommonConfigs.XAEROS_MAP_PYLON_WAYPOINT.get()).booleanValue()) {
                    WaystonesHelper.handle(serverPlayer, this.uuid);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.invalid_flow", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

