/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixed;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.mixed.IExtraSyncedData;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModLootTables;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.item.fishing.AbstractFishingPole;
import org.confluence.mod.common.item.fishing.IBait;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface IFishingHook
extends IExtraSyncedData<FishingHook> {
    public void confluence$setIsLavaHook();

    public boolean confluence$isLavaHook();

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    default public void confluence$setBait(@Nullable ItemStack bait) {
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    @Nullable
    default public ItemStack confluence$getBait() {
        return null;
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    default public float confluence$getBonus() {
        return 0.0f;
    }

    public static IFishingHook of(FishingHook fishingHook) {
        return (IFishingHook)fishingHook;
    }

    public static boolean checkAchievement(FishingHook self) {
        Player player;
        if (self.isInLava() && IFishingHook.of(self).confluence$isLavaHook() && (player = self.getPlayerOwner()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AchievementUtils.awardAchievement(player2, "hot_reels");
            return true;
        }
        return false;
    }

    public static boolean isValidBlock(FishingHook self, BlockState instance, Block block, boolean original) {
        if (original || instance.is((Block)ModBlocks.HONEY.get()) || instance.is((Block)ModBlocks.SHIMMER.get())) {
            return true;
        }
        return IFishingHook.of(self).confluence$isLavaHook() && self.isInLava() && instance.is(Blocks.LAVA);
    }

    public static TagKey<Fluid> isValidFluid(FishingHook self, TagKey<Fluid> original) {
        if (IFishingHook.of(self).confluence$isLavaHook()) {
            return ModTags.Fluids.FISHING_ABLE;
        }
        return ModTags.Fluids.NOT_LAVA;
    }

    public static ParticleOptions getFishingParticle(FishingHook self, ParticleOptions original) {
        return self.isInLava() ? ParticleTypes.FLAME : original;
    }

    public static ParticleOptions getBubbleParticle(FishingHook self, ParticleOptions original) {
        return self.isInLava() ? ParticleTypes.SMOKE : original;
    }

    public static ParticleOptions getSplashParticle(FishingHook self, ParticleOptions original) {
        return self.isInLava() ? ParticleTypes.LAVA : original;
    }

    public static LootParams modifyLuck(FishingHook self, LootParams params, ItemStack stack) {
        Player owner = self.getPlayerOwner();
        if (owner != null) {
            float luck = self.luck;
            luck += ((Float)TCUtils.getAccessoriesValue((LivingEntity)owner, AccessoryItems.FISHING$POWER)).floatValue();
            IBait bait = IBait.of(AbstractFishingPole.getBait((HolderLookup.Provider)self.registryAccess(), stack));
            if (bait != null) {
                luck *= 1.0f + bait.getBaitBonus();
            }
            params.luck = luck;
        }
        return params;
    }

    public static ResourceKey<LootTable> redirectLootTable(FishingHook self, ResourceKey<LootTable> original) {
        FluidState fluidState = self.getInBlockState().getFluidState();
        if (fluidState.is(FluidTags.LAVA)) {
            return ModLootTables.FISHING_LAVA;
        }
        if (fluidState.is(Tags.Fluids.HONEY)) {
            return ModLootTables.FISHING_HONEY;
        }
        if (self.getType() == EntityType.FISHING_BOBBER) {
            return original;
        }
        return ModLootTables.FISHING;
    }

    public static ObjectArrayList<ItemStack> modifyLoot(FishingHook self, ObjectArrayList<ItemStack> original) {
        Player player = self.getPlayerOwner();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerSpecialData data = PlayerSpecialData.of((Player)player2);
            ItemStack questedFish = data.getCurrentQuestedFish((Player)player2);
            if (!questedFish.isEmpty()) {
                data.removeCurrentQuestedFish();
                return ObjectArrayList.of((Object[])new ItemStack[]{questedFish});
            }
            int sample = player2.hasEffect(ModEffects.CRATE) ? 4 : 10;
            ServerLevel level = player2.serverLevel();
            if (level.random.nextInt(sample) == 0) {
                ResourceKey<LootTable> lootTable = IMinecraftServer.isHardmode(level.getServer()) ? ModLootTables.CRATE_HARDMODE : ModLootTables.CRATE;
                return level.getServer().reloadableRegistries().getLootTable(lootTable).getRandomItems(new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)self.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)self).create(LootContextParamSets.GIFT));
            }
        }
        return original;
    }
}

