/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.chunk;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.IPalettedContainer;
import org.confluence.mod.util.BlockCounts;
import org.confluence.mod.util.DynamicBiomeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LevelChunk.class})
public abstract class LevelChunkMixin
extends ChunkAccess {
    @Shadow
    @Final
    Level level;

    private LevelChunkMixin(ChunkPos chunkPos, UpgradeData upgradeData, LevelHeightAccessor levelHeightAccessor, Registry<Biome> biomeRegistry, long inhabitedTime, @Nullable LevelChunkSection[] sections, @Nullable BlendingData blendingData) {
        super(chunkPos, upgradeData, levelHeightAccessor, biomeRegistry, inhabitedTime, sections, blendingData);
    }

    @Inject(method={"<init>(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ProtoChunk;Lnet/minecraft/world/level/chunk/LevelChunk$PostLoadProcessor;)V"}, at={@At(value="RETURN")})
    private void protoToLevel(ServerLevel level, ProtoChunk chunk, LevelChunk.PostLoadProcessor postLoad, CallbackInfo ci) {
        DynamicBiomeUtils.applyDynamicBiome((ChunkAccess)chunk, (HolderLookup.RegistryLookup<Biome>)level.registryAccess().lookupOrThrow(Registries.BIOME));
    }

    @Inject(method={"setBlockState"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;")})
    private void setBlock(BlockPos pos, BlockState targetState, boolean isMoving, CallbackInfoReturnable<BlockState> cir, @Local LevelChunkSection section, @Local(ordinal=1) BlockState beforeState) {
        BlockCounts.Type after;
        BlockCounts.Type before = DynamicBiomeUtils.COUNTER.apply(beforeState);
        if (before == (after = DynamicBiomeUtils.COUNTER.apply(targetState))) {
            return;
        }
        if (before != null) {
            before.apply(ILevelChunkSection.of(section).confluence$getBlockCounts()).addAndGet(-1);
        }
        if (after != null) {
            after.apply(ILevelChunkSection.of(section).confluence$getBlockCounts()).addAndGet(1);
        }
        HolderLookup.RegistryLookup lookup = this.level.registryAccess().lookupOrThrow(Registries.BIOME);
        Holder<Biome> resultBiome = DynamicBiomeUtils.judgeSection(section, (HolderLookup.RegistryLookup<Biome>)lookup);
        LevelChunkSection aboveSection = this.confluence$getAboveSection(pos);
        Holder<Biome> aboveResult = this.confluence$checkAbove(pos, (HolderLookup.RegistryLookup<Biome>)lookup);
        if (resultBiome != null) {
            this.confluence$infect(section, resultBiome);
            if (aboveSection == null) {
                return;
            }
            if (aboveResult == null || DynamicBiomeUtils.PRIORITY.getInt((Object)resultBiome.getKey()) < DynamicBiomeUtils.PRIORITY.getInt((Object)aboveResult.getKey())) {
                this.confluence$infect(aboveSection, resultBiome);
            }
        } else {
            Holder<Biome> belowResult;
            if (aboveSection != null && aboveResult == null) {
                this.confluence$purify(aboveSection);
            }
            if ((belowResult = this.confluence$checkBelow(pos, (HolderLookup.RegistryLookup<Biome>)lookup)) != null) {
                this.confluence$infect(section, belowResult);
            } else {
                this.confluence$purify(section);
            }
        }
    }

    @Unique
    @Nullable
    private LevelChunkSection confluence$getAboveSection(BlockPos pPos) {
        BlockPos belowPos = pPos.offset(0, 16, 0);
        if (this.level.isOutsideBuildHeight(belowPos.getY())) {
            return null;
        }
        return this.getSection(this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord((int)belowPos.getY())));
    }

    @Unique
    @Nullable
    private Holder<Biome> confluence$checkAbove(BlockPos pPos, HolderLookup.RegistryLookup<Biome> lookup) {
        LevelChunkSection aboveSection = this.confluence$getAboveSection(pPos);
        if (aboveSection == null) {
            return null;
        }
        return DynamicBiomeUtils.judgeSection(aboveSection, lookup);
    }

    @Unique
    @Nullable
    private Holder<Biome> confluence$checkBelow(BlockPos pPos, HolderLookup.RegistryLookup<Biome> lookup) {
        BlockPos belowPos = pPos.offset(0, -16, 0);
        if (this.level.isOutsideBuildHeight(belowPos.getY())) {
            return null;
        }
        LevelChunkSection belowSection = this.getSection(this.getSectionIndexFromSectionY(SectionPos.blockToSectionCoord((int)belowPos.getY())));
        return DynamicBiomeUtils.judgeSection(belowSection, lookup);
    }

    @Unique
    private void confluence$purify(LevelChunkSection section) {
        if (this.level instanceof ServerLevel && section.getBiomes().maybeHas(biome -> biome.is(ModTags.Biomes.SPREADABLE))) {
            ILevelChunkSection iSection = ILevelChunkSection.of(section);
            iSection.confluence$setBiomes(iSection.confluence$getBackupBiome());
        }
    }

    @Unique
    private void confluence$infect(LevelChunkSection section, @NotNull Holder<Biome> biome) {
        if (((PalettedContainer)section.getBiomes()).data.palette().getSize() == 1 && section.getBiomes().maybeHas(b -> b == biome)) {
            return;
        }
        ILevelChunkSection.of(section).confluence$setBiomes((PalettedContainerRO<Holder<Biome>>)IPalettedContainer.recreateSingle(section.getBiomes(), biome));
    }
}

