/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.StartupConfigs;
import org.confluence.mod.client.event.ModClientSetups;
import org.confluence.mod.util.ClientUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={SpriteLoader.class})
public abstract class SpriteLoaderMixin {
    @Shadow
    @Final
    private ResourceLocation location;

    @ModifyVariable(method={"stitch"}, at=@At(value="HEAD"), argsOnly=true)
    private List<SpriteContents> generateGraySprites(List<SpriteContents> contents) {
        if (ModClientSetups.SHOULD_NOT_GENERATE_BLOCK_GRAY_TEXTURE || !StartupConfigs.paintsReplaceTexture()) {
            return contents;
        }
        if (InventoryMenu.BLOCK_ATLAS.equals((Object)this.location)) {
            ClientUtils.clearCache();
            ArrayList neoContents = Lists.newArrayListWithExpectedSize((int)(contents.size() * 2));
            HashSet<? extends String> bannedModForPaints = new HashSet<String>(StartupConfigs.bannedModForPaints());
            for (SpriteContents content : contents) {
                neoContents.add(content);
                ResourceLocation name = content.name();
                if (!name.getPath().startsWith("block/") || bannedModForPaints.contains(name.getNamespace())) continue;
                ClientUtils.ORIGINAL.add(name);
                FrameSize frameSize = new FrameSize(content.width(), content.height());
                NativeImage grayImage = LibClientUtils.copyWithGray((NativeImage)content.getOriginalImage());
                SpriteContents grayContent = new SpriteContents(name.withSuffix(".gray"), frameSize, grayImage, content.metadata());
                neoContents.add(grayContent);
                NativeImage negativeImage = LibClientUtils.copyWithNegative((NativeImage)content.getOriginalImage());
                SpriteContents negativeContent = new SpriteContents(name.withSuffix(".negative"), frameSize, negativeImage, content.metadata());
                neoContents.add(negativeContent);
            }
            return neoContents;
        }
        return contents;
    }
}

