/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.client.entity;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.client.effect.GlowingHelper;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.mixed.IEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityClientMixin
implements IEntity {
    @Unique
    private Vec3 confluence$deathMotion;

    @Inject(method={"getTeamColor"}, at={@At(value="HEAD")}, cancellable=true)
    private void getTeamColor(CallbackInfoReturnable<Integer> cir) {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasEffect(ModEffects.HUNTER)) {
            GlowingHelper helper = GlowingHelper.INSTANCE;
            for (Map.Entry<Class<? extends Entity>, GlowingHelper.Data> entry : helper.colorMap.entrySet()) {
                if (!entry.getKey().isAssignableFrom(((Entity)this.confluence$self()).getClass())) continue;
                cir.setReturnValue((Object)entry.getValue().color().getRGB());
                return;
            }
            if (this.confluence$self() instanceof Enemy) {
                cir.setReturnValue((Object)helper.enemyColor.getRGB());
                return;
            }
            if (this.confluence$self() instanceof NeutralMob) {
                cir.setReturnValue((Object)helper.neutralColor.getRGB());
                return;
            }
            cir.setReturnValue((Object)helper.defaultColor.getRGB());
        }
    }

    @Override
    public Vec3 confluence$deathMotion(Vec3 ... motion) {
        if (motion != null && motion.length > 0) {
            this.confluence$deathMotion = motion[0];
        }
        return this.confluence$deathMotion;
    }
}

