/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.entity;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import org.confluence.mod.common.init.ModVillagers;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.terra_curio.util.TCUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Villager.class})
public abstract class VillagerMixin {
    @ModifyExpressionValue(method={"updateSpecialPrices"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;hasEffect(Lnet/minecraft/core/Holder;)Z")})
    private boolean hasSpecialOffer(boolean original, @Local(argsOnly=true) Player player, @Share(value="specialPrice") LocalIntRef specialPrice) {
        int value = (Integer)TCUtils.getAccessoriesValue((LivingEntity)player, AccessoryItems.SPECIAL$PRICE);
        specialPrice.set(value);
        return original || value > 0;
    }

    @ModifyExpressionValue(method={"updateSpecialPrices"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffectInstance;getAmplifier()I")})
    private int modifyAmplifier(int original, @Local MobEffectInstance effectInstance, @Share(value="specialPrice") LocalIntRef specialPrice) {
        int value = specialPrice.get();
        if (value > 0) {
            if (effectInstance == null) {
                return value - 1;
            }
            return value;
        }
        return original;
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="RETURN")})
    private void setVillagerType(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnGroupData, CallbackInfoReturnable<SpawnGroupData> cir) {
        ModVillagers.setVillagerType((Villager)this);
    }
}

