/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.ars_nouveau;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.integration.ars_nouveau.ArsNouveauHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.hollingsworth.arsnouveau.common.capability.ManaCap"}, remap=false)
public abstract class ManaCapMixin {
    @Shadow
    LivingEntity entity;
    @Unique
    private Optional<ManaStorage> confluence$manaStorage = Optional.empty();
    @Unique
    private boolean confluence$isServerSide = false;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(LivingEntity livingEntity, CallbackInfo ci) {
        if (((Boolean)CommonConfigs.CONVERT_ARS_NOUVEAU_MANA.get()).booleanValue() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.confluence$manaStorage = Optional.of(ManaStorage.of((LivingEntity)player));
            this.confluence$isServerSide = player instanceof ServerPlayer;
        }
    }

    @Inject(method={"setMaxMana"}, at={@At(value="TAIL")})
    private void updateMana(int maxMana, CallbackInfo ci) {
        ArsNouveauHelper.updateMana(this.entity);
    }

    @Inject(method={"removeMana"}, at={@At(value="RETURN")})
    private void removeData(double manaToRemove, CallbackInfoReturnable<Double> cir) {
        if (this.confluence$isServerSide) {
            this.confluence$manaStorage.ifPresent(storage -> ArsNouveauHelper.extractMana((ServerPlayer)this.entity, storage, manaToRemove));
        }
    }
}

