/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.terra_entity;

import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.confluence.lib.mixed.SelfGetter;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.integration.terra_entity.IAbstractTerraNPC;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.house.House;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractTerraNPC.class}, remap=false)
public abstract class AbstractTerraNPCMixin
implements IAbstractTerraNPC,
SelfGetter<AbstractTerraNPC> {
    @Unique
    private NPCSpawner.Region confluence$region = NPCSpawner.Region.ZERO;
    @Unique
    private boolean confluence$shouldInteract = false;

    @Shadow
    public abstract void initName();

    @Override
    public void confluence$setRegion(NPCSpawner.Region region) {
        this.confluence$region = region;
    }

    @Override
    public NPCSpawner.Region confluence$getRegion() {
        return this.confluence$region;
    }

    @Override
    public void confluence$setShouldInteract(boolean should) {
        this.confluence$shouldInteract = should;
    }

    @Override
    public boolean confluence$shouldInteract() {
        return this.confluence$shouldInteract;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(EntityType<? extends AbstractTerraNPC> entityType, Level level, CallbackInfo ci) {
        this.initName();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void read(CompoundTag tag, CallbackInfo ci) {
        if (tag.contains("confluence:region")) {
            this.confluence$region = NPCSpawner.Region.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("confluence:region")).result().orElse(NPCSpawner.Region.ZERO);
        }
        this.confluence$shouldInteract = tag.getBoolean("confluence:should_interact");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void save(CompoundTag tag, CallbackInfo ci) {
        NPCSpawner.Region.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.confluence$region).ifSuccess(tag1 -> tag.put("confluence:region", tag1));
        tag.putBoolean("confluence:should_interact", this.confluence$shouldInteract);
    }

    @Inject(method={"setHouse"}, at={@At(value="HEAD")})
    private void setRegion(House house, CallbackInfo ci) {
        if (!house.isEmpty()) {
            NPCSpawner.Region region = new NPCSpawner.Region(house.center());
            NPCSpawner.INSTANCE.moveNPCToAnotherRegion((AbstractTerraNPC)this.confluence$self(), this.confluence$getRegion(), region);
            AchievementUtils.noHobo((AbstractTerraNPC)this.confluence$self(), region);
        }
    }

    @Inject(method={"removeWhenFarAway"}, at={@At(value="HEAD")}, cancellable=true)
    private void denyRemove(double distanceToClosestPlayer, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
    }
}

