/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.integration.touhoulittlemaid;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.projectile.MaidFishingHook;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.confluence.lib.mixed.SelfGetter;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModLootTables;
import org.confluence.mod.common.item.fishing.AbstractFishingPole;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com/github/tartaricacid/touhoulittlemaid/entity/projectile/MaidFishingHook"}, remap=false)
public abstract class MaidFishingHookMixin
implements SelfGetter<MaidFishingHook> {
    @Shadow
    @Nullable
    public abstract EntityMaid getMaidOwner();

    @Inject(method={"getLoot"}, at={@At(value="RETURN")}, cancellable=true)
    private void getLootMixin(MinecraftServer server, LootParams lootParams, CallbackInfoReturnable<List<ItemStack>> cir) {
        Item item;
        if (this.getMaidOwner() != null && (item = this.getMaidOwner().getMainHandItem().getItem()) instanceof AbstractFishingPole) {
            AbstractFishingPole pole = (AbstractFishingPole)item;
            cir.setReturnValue((Object)server.reloadableRegistries().getLootTable(ModLootTables.FISHING).getRandomItems(lootParams));
        }
    }

    @Inject(method={"addExtraLoot"}, at={@At(value="RETURN")})
    private void addExtraLootMixin(List<ItemStack> randomItems, CallbackInfo ci) {
        if (this.getMaidOwner() != null) {
            float chance = this.getMaidOwner().hasEffect(ModEffects.CRATE) ? 0.25f : 0.1f;
            Level level = this.getMaidOwner().level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                if (level2.random.nextFloat() < chance) {
                    randomItems.addAll((Collection<ItemStack>)level2.getServer().reloadableRegistries().getLootTable(ModLootTables.CRATE).getRandomItems(new LootParams.Builder(level2).withParameter(LootContextParams.ORIGIN, (Object)((MaidFishingHook)this.confluence$self()).position()).withParameter(LootContextParams.THIS_ENTITY, (Object)((Entity)this.confluence$self())).create(LootContextParamSets.GIFT)));
                }
            }
        }
    }
}

