/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.item;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.item.bow.BaseArrowItem;
import org.confluence.mod.common.item.bow.TerraBowItem;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ArrowItem.class}, priority=1100)
public abstract class ArrowItemMixin {
    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/Item;<init>(Lnet/minecraft/world/item/Item$Properties;)V"))
    private static Item.Properties maxStack(Item.Properties properties) {
        int size;
        int value = 9999;
        if (properties.components != null && !properties.components.map.containsKey((Object)DataComponents.DAMAGE) && (size = ((Integer)properties.components.map.getOrDefault((Object)DataComponents.MAX_STACK_SIZE, (Object)1)).intValue()) > value) {
            value = size;
        }
        return properties.stacksTo(value);
    }

    @Inject(method={"createArrow"}, at={@At(value="HEAD")}, cancellable=true)
    public void createArrow(Level level, ItemStack ammo, LivingEntity shooter, @Nullable ItemStack weapon, CallbackInfoReturnable<AbstractArrow> cir) {
        Item item;
        if (weapon != null && (item = weapon.getItem()) instanceof TerraBowItem) {
            TerraBowItem bow = (TerraBowItem)item;
            TerraBowItem.Builder builder = bow.modifyArrowBuilder;
            if (builder.entityTransform != null) {
                BaseArrowEntity arrow = builder.entityTransform.factory().create(builder.entityTransform.type(), shooter, ammo.copyWithCount(1), weapon, null, bow.modifyArrowBuilder);
                cir.setReturnValue((Object)arrow);
                return;
            }
            BaseArrowItem arrowItem = bow.arrowModifier.getTransformArrow();
            if (arrowItem != null) {
                cir.setReturnValue((Object)new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), shooter, ammo.copyWithCount(1), weapon, arrowItem, bow.modifyArrowBuilder));
            }
        }
    }
}

