/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.mixed.SelfGetter;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.confluence.mod.common.item.bow.TerraBowItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin
implements SelfGetter<BowItem> {
    @WrapOperation(method={"releaseUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/BowItem;getPowerForTime(I)F")})
    private float shortBowPower(int pCharge, Operation<Float> original, @Local(argsOnly=true) ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof ShortBowItem) {
            ShortBowItem shortBow = (ShortBowItem)item;
            return shortBow.getShortPowerForTime(pCharge);
        }
        if (itemStack.is(ModTags.Items.FAST_BOW)) {
            return TerraBowItem.getFastBowPowerForTime(pCharge);
        }
        return ((Float)original.call(new Object[]{pCharge})).floatValue();
    }

    @WrapOperation(method={"shootProjectile"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;shootFromRotation(Lnet/minecraft/world/entity/Entity;FFFFF)V")})
    private void shortBowSoot(Projectile instance, Entity shooter, float x, float y, float z, float velocity, float inaccuracy, Operation<Void> original) {
        Object object = this.confluence$self();
        if (object instanceof ShortBowItem) {
            ShortBowItem shortBow = (ShortBowItem)((Object)object);
            original.call(new Object[]{instance, shooter, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(velocity * shortBow.getVelocityMultiplier() / 3.0f), Float.valueOf(inaccuracy)});
        } else {
            original.call(new Object[]{instance, shooter, Float.valueOf(x), Float.valueOf(y), Float.valueOf(z), Float.valueOf(velocity), Float.valueOf(inaccuracy)});
        }
    }
}

