/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.PlayerAboutToEmptyTargetSweepEvent;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.mixin.ServerPlayerAccessor;
import org.confluence.mod.network.c2s.IPacketC2S;
import org.confluence.mod.util.PlayerUtils;

public final class EmptyTargetSweepPacketC2S
implements IPacketC2S {
    private static final EmptyTargetSweepPacketC2S INSTANCE = new EmptyTargetSweepPacketC2S();
    public static final CustomPacketPayload.Type<EmptyTargetSweepPacketC2S> TYPE = new CustomPacketPayload.Type(Confluence.asResource("empty_target_sweep"));
    public static final StreamCodec<ByteBuf, EmptyTargetSweepPacketC2S> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

    private EmptyTargetSweepPacketC2S() {
    }

    public CustomPacketPayload.Type<EmptyTargetSweepPacketC2S> type() {
        return TYPE;
    }

    @Override
    public void work(ServerPlayer player) {
        if (PlayerUtils.couldPerformEmptyTargetSweep((Player)player)) {
            float damage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            if (player.getAttackStrengthScale(0.5f) < 0.99999f) {
                return;
            }
            float baseDamage = 1.0f + (float)player.getAttributeValue(Attributes.SWEEPING_DAMAGE_RATIO) * damage;
            PlayerAboutToEmptyTargetSweepEvent event = (PlayerAboutToEmptyTargetSweepEvent)NeoForge.EVENT_BUS.post((Event)new PlayerAboutToEmptyTargetSweepEvent((Player)player, baseDamage));
            if (event.isCanceled()) {
                return;
            }
            float attackDamage = event.getAttackDamage();
            DamageSource source = player.damageSources().playerAttack((Player)player);
            for (LivingEntity target : player.level().getEntitiesOfClass(LivingEntity.class, BaseSwordItem.getSpecialSweepArea((Player)player))) {
                double entityReachSq = Mth.square((double)player.entityInteractionRange());
                if (target == player || player.isAlliedTo((Entity)target) || target instanceof ArmorStand && ((ArmorStand)target).isMarker() || !(player.distanceToSqr((Entity)target) < entityReachSq)) continue;
                target.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                float amount = ((ServerPlayerAccessor)player).callGetEnchantedDamage((Entity)target, attackDamage, source);
                target.hurt(source, amount);
                EnchantmentHelper.doPostAttackEffects((ServerLevel)player.serverLevel(), (Entity)target, (DamageSource)source);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
            player.sweepAttack();
            player.swing(InteractionHand.MAIN_HAND, false);
        }
    }

    public static void send2Server() {
        PacketDistributor.sendToServer((CustomPacketPayload)INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

