/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.mod.common.menu.DyeMixMenu;
import org.confluence.mod.common.menu.DyeVatMenu;
import org.confluence.mod.common.menu.ExtraInventoryMenu;
import org.confluence.mod.common.menu.NPCReforgeMenu;
import org.confluence.mod.common.menu.NPCTradesForgeMenu;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.c2s.IPacketC2S;
import org.confluence.mod.network.s2c.AvailableHouseSelectPacketS2C;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;

public record OpenMenuPacketC2S(byte menuId, ItemStack stack) implements IPacketC2S
{
    public static final byte EXTRA_INVENTORY = 0;
    public static final byte MAID_TRADE_MENU = 1;
    public static final byte NPC_REFORGE_MENU = 2;
    public static final byte DYE_VAT_MENU = 3;
    public static final byte DYE_MIX_MENU = 4;
    private static final Object2ObjectMap<Byte, Tuple<MenuConstructor, Component>> MENU_TYPES = (Object2ObjectMap)Util.make((Object)new Object2ObjectOpenHashMap(), map -> {
        map.put((Object)0, (Object)new Tuple((containerId, playerInventory, player) -> new ExtraInventoryMenu(containerId, playerInventory), (Object)Component.empty()));
        map.put((Object)1, (Object)new Tuple((containerId, playerInventory, player) -> new NPCTradesForgeMenu(containerId, playerInventory), (Object)Component.translatable((String)"title.confluence.touhoulittlemaid")));
        map.put((Object)2, (Object)new Tuple((containerId, playerInventory, player) -> new NPCReforgeMenu(containerId, playerInventory), (Object)Component.empty()));
        map.put((Object)3, (Object)new Tuple((containerId, playerInventory, player) -> new DyeVatMenu(containerId, playerInventory, OpenMenuPacketC2S.getAccess(player)), (Object)Component.translatable((String)"container.confluence.dye_vat")));
        map.put((Object)4, (Object)new Tuple((containerId, playerInventory, player) -> new DyeMixMenu(containerId, playerInventory, OpenMenuPacketC2S.getAccess(player)), (Object)Component.translatable((String)"container.confluence.dye_mix")));
    });
    public static final CustomPacketPayload.Type<OpenMenuPacketC2S> TYPE = IPacket.createType("open_menu");
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenMenuPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BYTE, OpenMenuPacketC2S::menuId, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, OpenMenuPacketC2S::stack, OpenMenuPacketC2S::new);

    private static ContainerLevelAccess getAccess(Player player) {
        Vec3 start = player.getEyePosition(0.5f);
        Vec3 lookVector = player.getViewVector(0.5f);
        double range = Math.max(player.blockInteractionRange(), player.entityInteractionRange());
        Vec3 end = start.add(lookVector.x * range, lookVector.y * range, lookVector.z * range);
        ClipContext context = new ClipContext(start, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, CollisionContext.of((Entity)player));
        BlockHitResult blockResult = player.level().clip(context);
        if (blockResult.getType() == HitResult.Type.BLOCK) {
            return ContainerLevelAccess.create((Level)player.level(), (BlockPos)blockResult.getBlockPos());
        }
        return ContainerLevelAccess.NULL;
    }

    public CustomPacketPayload.Type<OpenMenuPacketC2S> type() {
        return TYPE;
    }

    @Override
    public void work(ServerPlayer player) {
        Tuple tuple = (Tuple)MENU_TYPES.get((Object)this.menuId);
        if (tuple != null) {
            ItemStack itemStack = player.isCreative() ? this.stack : player.containerMenu.getCarried();
            player.containerMenu.setCarried(ItemStack.EMPTY);
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)tuple.getA(), (Component)tuple.getB()));
            CustomPacketPayload[] payloads = new CustomPacketPayload[]{};
            if (!itemStack.isEmpty()) {
                player.containerMenu.setCarried(itemStack);
                payloads = new CustomPacketPayload[]{new SPacketGrabbedItem(itemStack)};
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)AvailableHouseSelectPacketS2C.collectPacket(player), (CustomPacketPayload[])payloads);
        }
    }

    public static void sendToServer(byte menuId, ItemStack stack) {
        PacketDistributor.sendToServer((CustomPacketPayload)new OpenMenuPacketC2S(menuId, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

