/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.c2s;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.init.item.PotionItems;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.c2s.IPacketC2S;

public record WormholeToPlayerPacketC2S(UUID playerId, ByMod byMod) implements IPacketC2S
{
    public static final CustomPacketPayload.Type<WormholeToPlayerPacketC2S> TYPE = IPacket.createType("wormhole_to_player");
    public static final StreamCodec<FriendlyByteBuf, WormholeToPlayerPacketC2S> STREAM_CODEC = StreamCodec.composite((StreamCodec)LibStreamCodecUtils.UUID, WormholeToPlayerPacketC2S::playerId, ByMod.STREAM_CODEC, WormholeToPlayerPacketC2S::byMod, WormholeToPlayerPacketC2S::new);

    public CustomPacketPayload.Type<WormholeToPlayerPacketC2S> type() {
        return TYPE;
    }

    @Override
    public void work(ServerPlayer player) {
        if (!this.byMod.enabled()) {
            return;
        }
        ServerPlayer target = player.server.getPlayerList().getPlayer(this.playerId);
        if (target != null && player.getTeam() == target.getTeam()) {
            ItemStack potion = WormholeToPlayerPacketC2S.getWormholePotion(player);
            if (potion.isEmpty()) {
                return;
            }
            if (!player.hasInfiniteMaterials()) {
                potion.shrink(1);
            }
            this.teleport(player, target);
        }
    }

    public static boolean isTrackable(ServerPlayer trackingPlayer, ServerPlayer trackedPlayer) {
        return trackingPlayer != trackedPlayer && trackingPlayer.getTeam() == trackedPlayer.getTeam();
    }

    private static ItemStack getWormholePotion(ServerPlayer serverPlayer) {
        Inventory inventory = serverPlayer.getInventory();
        ItemStack stack = (ItemStack)inventory.offhand.getFirst();
        if (!stack.isEmpty() && stack.is(PotionItems.WORMHOLE_POTION)) {
            return stack;
        }
        for (ItemStack itemStack : inventory.items) {
            if (itemStack.isEmpty() || !itemStack.is(PotionItems.WORMHOLE_POTION)) continue;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    private void teleport(ServerPlayer serverPlayer, ServerPlayer target) {
        serverPlayer.teleportTo(serverPlayer.serverLevel(), target.getX(), target.getY(), target.getZ(), serverPlayer.getXRot(), serverPlayer.getYRot());
    }

    public static enum ByMod {
        FTB_CHUNKS{

            @Override
            public boolean enabled() {
                return (Boolean)CommonConfigs.FTB_CHUNKS_WORMHOLE_POTION.get();
            }
        }
        ,
        XAEROS_MAP{

            @Override
            public boolean enabled() {
                return (Boolean)CommonConfigs.XAEROS_MAP_WORMHOLE_POTION.get();
            }
        };

        public static final ByMod[] VALUES;
        public static final StreamCodec<ByteBuf, ByMod> STREAM_CODEC;

        public abstract boolean enabled();

        static {
            VALUES = ByMod.values();
            STREAM_CODEC = ByteBufCodecs.VAR_INT.map(i -> VALUES[i], Enum::ordinal);
        }
    }
}

