/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.lib.util.LibStreamCodecUtils;
import org.confluence.mod.api.event.bestiary.RegisterBestiaryKeyEvent;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.common.data.saved.BestiaryEntry;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.s2c.IPacketS2C;

public record BestiarySyncPacketS2C(Either<Map<String, BestiaryEntry>, String> either) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<BestiarySyncPacketS2C> TYPE = IPacket.createType("bestiary_sync");
    public static final StreamCodec<ByteBuf, BestiarySyncPacketS2C> STREAM_CODEC = ByteBufCodecs.either((StreamCodec)LibStreamCodecUtils.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, BestiaryEntry.STREAM_CODEC), (StreamCodec)ByteBufCodecs.STRING_UTF8).map(BestiarySyncPacketS2C::new, BestiarySyncPacketS2C::either);

    public CustomPacketPayload.Type<BestiarySyncPacketS2C> type() {
        return TYPE;
    }

    @Override
    public void work(Player player) {
        ClientBestiary.getInstance().handle(this.either);
    }

    public static void syncEntries(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BestiarySyncPacketS2C((Either<Map<String, BestiaryEntry>, String>)Either.left(Bestiary.INSTANCE.getEntries())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void syncEntry(LivingEntity living) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BestiarySyncPacketS2C((Either<Map<String, BestiaryEntry>, String>)Either.right((Object)RegisterBestiaryKeyEvent.getKey(living))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void syncEntry(LivingEntity living, BestiaryEntry entry) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new BestiarySyncPacketS2C((Either<Map<String, BestiaryEntry>, String>)Either.left(Map.of(RegisterBestiaryKeyEvent.getKey(living), entry))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

