/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.confluence.mod.client.handler.StarPhaseHandler;
import org.confluence.mod.common.data.saved.StarPhase;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.s2c.IPacketS2C;

public record StarPhasesPacketS2C(Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>> starPhases) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<StarPhasesPacketS2C> TYPE = IPacket.createType("star_phases");
    public static final StreamCodec<ByteBuf, StarPhasesPacketS2C> STREAM_CODEC = new StreamCodec<ByteBuf, StarPhasesPacketS2C>(){

        public StarPhasesPacketS2C decode(ByteBuf buffer) {
            boolean isLeft = buffer.readBoolean();
            if (isLeft) {
                int length = buffer.readInt();
                Int2ObjectArrayMap map = new Int2ObjectArrayMap();
                for (int i = 0; i < length; ++i) {
                    map.put(i, (Object)new StarPhase(buffer));
                }
                return new StarPhasesPacketS2C((Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>>)Either.left((Object)map));
            }
            return new StarPhasesPacketS2C((Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>>)Either.right((Object)new AbstractInt2ObjectMap.BasicEntry(buffer.readInt(), (Object)new StarPhase(buffer))));
        }

        public void encode(ByteBuf buffer, StarPhasesPacketS2C value) {
            value.starPhases.ifLeft(map -> {
                buffer.writeBoolean(true);
                buffer.writeInt(10);
                for (int i = 0; i < 10; ++i) {
                    ((StarPhase)map.getOrDefault(i, (Object)StarPhase.DEFAULT)).writeTo(buffer);
                }
            }).ifRight(entry -> {
                buffer.writeBoolean(false);
                buffer.writeInt(entry.getIntKey());
                ((StarPhase)entry.getValue()).writeTo(buffer);
            });
        }
    };

    public CustomPacketPayload.Type<StarPhasesPacketS2C> type() {
        return TYPE;
    }

    @Override
    public void work(Player player) {
        StarPhaseHandler.handleStarPhases(this.starPhases);
    }

    public static void sendToAll(int index, int timeOffset, float radius, float angle) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new StarPhasesPacketS2C((Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>>)Either.right((Object)new AbstractInt2ObjectMap.BasicEntry(index, (Object)new StarPhase(timeOffset, radius, angle)))), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClient(ServerPlayer serverPlayer, Int2ObjectMap<StarPhase> starPhases) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new StarPhasesPacketS2C((Either<Int2ObjectMap<StarPhase>, Int2ObjectMap.Entry<StarPhase>>)Either.left(starPhases)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

