/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.SectionPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.s2c.IPacketS2C;
import org.confluence.mod.util.TerraStyleExplosion;

public record TerraStyleExplosionPacketS2C(double x, double y, double z, float radius) implements IPacketS2C
{
    public static final CustomPacketPayload.Type<TerraStyleExplosionPacketS2C> TYPE = IPacket.createType("terra_style_explosion");
    public static final StreamCodec<ByteBuf, TerraStyleExplosionPacketS2C> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, TerraStyleExplosionPacketS2C::x, (StreamCodec)ByteBufCodecs.DOUBLE, TerraStyleExplosionPacketS2C::y, (StreamCodec)ByteBufCodecs.DOUBLE, TerraStyleExplosionPacketS2C::z, (StreamCodec)ByteBufCodecs.FLOAT, TerraStyleExplosionPacketS2C::radius, TerraStyleExplosionPacketS2C::new);

    public CustomPacketPayload.Type<TerraStyleExplosionPacketS2C> type() {
        return TYPE;
    }

    @Override
    public void work(Player player) {
        TerraStyleExplosion.handleClientExplode(player.level(), this.x, this.y, this.z, this.radius);
    }

    public static void send2All(ServerLevel level, double x, double y, double z, float radius) {
        ChunkPos chunkPos = new ChunkPos(SectionPos.blockToSectionCoord((double)x), SectionPos.blockToSectionCoord((double)z));
        TerraStyleExplosionPacketS2C packet = new TerraStyleExplosionPacketS2C(x, y, z, radius);
        for (ServerPlayer player : level.players()) {
            if (!player.getChunkTrackingView().contains(chunkPos)) continue;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

