/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.network.s2c;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.common.item.IFunctionCouldEnable;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.handler.ClientPacketHandler;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.network.IPacket;
import org.confluence.mod.network.s2c.IPacketS2C;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terra_curio.util.CuriosUtils;
import org.confluence.terra_curio.util.TCUtils;

public record VisibilityPacketS2C(byte mask) implements IPacketS2C
{
    public static final byte ECHO = 2;
    public static final byte THE_CONSTANT_POST_EFFECT = 4;
    public static final byte SIGNAL = 8;
    public static final CustomPacketPayload.Type<VisibilityPacketS2C> TYPE = IPacket.createType("visibility");
    public static final StreamCodec<ByteBuf, VisibilityPacketS2C> STREAM_CODEC = ByteBufCodecs.BYTE.map(VisibilityPacketS2C::new, VisibilityPacketS2C::mask);

    public VisibilityPacketS2C(byte checkMask, boolean visible) {
        this((byte)(checkMask | (visible ? (byte)1 : 0)));
    }

    public CustomPacketPayload.Type<VisibilityPacketS2C> type() {
        return TYPE;
    }

    @Override
    public void work(Player player) {
        ClientPacketHandler.handleVisibility(this.mask, (this.mask & 1) != 0);
    }

    public static void sendEcho(ServerPlayer player) {
        boolean visible = TCUtils.hasAccessoriesType((LivingEntity)player, AccessoryItems.SPECTRE$GOGGLES) && CuriosUtils.hasCurio((LivingEntity)player, itemStack -> {
            AccessoriesComponent component;
            IFunctionCouldEnable func;
            Item patt0$temp = itemStack.getItem();
            if (patt0$temp instanceof IFunctionCouldEnable && (func = (IFunctionCouldEnable)patt0$temp).isEnabled(itemStack) && (component = TCUtils.getAccessoriesComponent((ItemStack)itemStack)) != null) {
                return component.contains(AccessoryItems.SPECTRE$GOGGLES);
            }
            return false;
        });
        CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player);
        if (data.getBoolean("confluence:has_echo_visibility") != visible) {
            data.putBoolean("confluence:has_echo_visibility", visible);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new VisibilityPacketS2C(2, visible), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendTheConstantPostEffect(ServerPlayer serverPlayer) {
        boolean secretSeed = ModSecretSeeds.THE_CONSTANT.match(serverPlayer.server);
        boolean accessory = CuriosUtils.hasCurio((LivingEntity)serverPlayer, (Item)((BaseCurioItem)AccessoryItems.RADIO_THING.get()));
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new VisibilityPacketS2C(4, secretSeed ^ accessory), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSignal(ServerPlayer serverPlayer, boolean visible) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new VisibilityPacketS2C(8, visible), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

