/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.google.common.collect.Streams;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.block.functional.DartTrapBlock;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.IMinecraftServer;
import org.confluence.mod.util.DynamicBiomeUtils;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;

public final class AchievementUtils {
    public static final String PREFIX = "achievements/";

    public static ResourceLocation asAchievement(String path) {
        return Confluence.asResource(PREFIX + path);
    }

    public static boolean achievedAchievement(ServerPlayer player, String path) {
        if (LibUtils.getOrCreatePersistedData((Player)player).getBoolean(Confluence.asPlainId(path))) {
            return true;
        }
        AdvancementHolder advancement = player.server.getAdvancements().get(AchievementUtils.asAchievement(path));
        return advancement != null && player.getAdvancements().getOrStartProgress(advancement).isDone();
    }

    public static void awardAchievement(ServerPlayer player, String path) {
        String key;
        CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player);
        if (!data.getBoolean(key = Confluence.asPlainId(path))) {
            AdvancementHolder advancement = player.server.getAdvancements().get(AchievementUtils.asAchievement(path));
            if (advancement != null) {
                player.getAdvancements().award(advancement, "never");
            }
            data.putBoolean(key, true);
        }
    }

    public static void youCanDoIt(ServerPlayer player, ServerLevel level) {
        if (level.getGameTime() % 1200L == 0L) {
            byte firstNight = LibUtils.getOrCreatePersistedData((Player)player).getByte("confluence:you_can_do_it");
            if (firstNight == -1) {
                return;
            }
            int dayTime = LibDateUtils.getDayTime((Level)level);
            if (LibDateUtils.isNight((int)dayTime)) {
                LibUtils.getOrCreatePersistedData((Player)player).putByte("confluence:you_can_do_it", (byte)1);
            } else if (firstNight == 1 && LibDateUtils.isDay((int)dayTime)) {
                AdvancementHolder advancement = player.server.getAdvancements().get(AchievementUtils.asAchievement("you_can_do_it"));
                if (advancement != null) {
                    player.getAdvancements().award(advancement, "never");
                }
                LibUtils.getOrCreatePersistedData((Player)player).putByte("confluence:you_can_do_it", (byte)-1);
            }
        }
    }

    public static boolean marathonMedalist(ServerPlayer player, ServerStatsCounter stats, boolean marathon) {
        int walk;
        int crouch;
        if (marathon) {
            return true;
        }
        int sprint = stats.getValue(Stats.CUSTOM.get((Object)Stats.SPRINT_ONE_CM));
        if (sprint + (crouch = stats.getValue(Stats.CUSTOM.get((Object)Stats.CROUCH_ONE_CM))) + (walk = stats.getValue(Stats.CUSTOM.get((Object)Stats.WALK_ONE_CM))) > 4611200) {
            AdvancementHolder advancement = player.server.getAdvancements().get(AchievementUtils.asAchievement("marathon_medalist"));
            if (advancement != null) {
                player.getAdvancements().award(advancement, "never");
            }
            return true;
        }
        return false;
    }

    public static void luckyBreak_watchYourStep(ServerPlayer player, DamageSource damageSource, Entity sourceEntity) {
        if (player.isAlive()) {
            if (player.getHealth() / player.getMaxHealth() < 0.1f && damageSource.is(DamageTypeTags.IS_FALL)) {
                AchievementUtils.awardAchievement(player, "lucky_break");
            }
        } else if (sourceEntity != null && DartTrapBlock.NAME.equals((Object)sourceEntity.getCustomName())) {
            AchievementUtils.awardAchievement(player, "watch_your_step");
        }
    }

    public static void matchingAttire_fashionStatement(EquipmentSlot slot, ServerPlayer player) {
        if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && Streams.stream((Iterable)player.getArmorSlots()).noneMatch(ItemStack::isEmpty)) {
            AchievementUtils.awardAchievement(player, "matching_attire");
            ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
            boolean fashionStatement = true;
            for (int i = 0; i < 4; ++i) {
                if (!extraInventory.getVanityArmor(i, false).isEmpty()) continue;
                fashionStatement = false;
                break;
            }
            if (fashionStatement) {
                AchievementUtils.awardAchievement(player, "fashion_statement");
            }
        }
    }

    public static void theFrequentFlyer(ServerPlayer player, long cost) {
        AdvancementHolder advancement;
        CompoundTag tag = LibUtils.getOrCreatePersistedData((Player)player);
        short before = tag.getShort("confluence:the_frequent_flyer");
        if (before > 10000) {
            return;
        }
        long total = (long)before + cost;
        if (total >= 10000L && (advancement = player.server.getAdvancements().get(AchievementUtils.asAchievement("the_frequent_flyer"))) != null) {
            player.getAdvancements().award(advancement, "never");
        }
        tag.putShort("confluence:the_frequent_flyer", (short)total);
    }

    public static void noHobo(AbstractTerraNPC npc, NPCSpawner.Region region) {
        Level level = npc.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer player : serverLevel.players()) {
                if (!region.isOnRegion(player.chunkPosition())) continue;
                AchievementUtils.awardAchievement(player, "no_hobo");
            }
        }
    }

    public static void quietNeighborhood(ServerPlayer player, ServerLevel level) {
        ILevelChunkSection iSection;
        if (level.getGameTime() % 40L == 2L && (iSection = DynamicBiomeUtils.getISection((LevelAccessor)level, player.blockPosition())) != null && iSection.confluence$isGraveyard()) {
            AchievementUtils.awardAchievement(player, "quiet_neighborhood");
        }
    }

    public static void aRareRealm(ServerPlayer player, ServerLevel level) {
        if (IMinecraftServer.of(player.server).confluence$matchesSecretFlag(0x7FFFFFFFFFFFFF00L) && level.getGameTime() % 40L == 3L) {
            AchievementUtils.awardAchievement(player, "a_rare_realm");
        }
    }

    public static void unusualSurvivalStrategies(ServerPlayer player, boolean isWatterBottle) {
        if (isWatterBottle && player.isInWater() && player.getAirSupply() <= 0) {
            AchievementUtils.awardAchievement(player, "unusual_survival_strategies");
        }
    }
}

