/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mojang.math.Transformation;
import com.xiaohunao.mine_team.common.team.Team;
import com.xiaohunao.mine_team.common.team.TeamManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ClientHooks;
import org.confluence.lib.client.AntiPushPoseStack;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.block.functional.BoulderBlock;
import org.confluence.mod.common.entity.DeadBodyPartEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.common.BaseDyeItem;
import org.confluence.mod.common.worldgen.secret_seed.TheConstant;
import org.confluence.mod.integration.geckolib.IGeoCube;
import org.confluence.mod.mixed.IEntity;
import org.confluence.mod.mixed.ILivingEntityRenderer;
import org.confluence.mod.mixin.client.accessor.AgeableListModelAccessor;
import org.confluence.mod.util.DeathAnimUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public final class ClientUtils {
    public static final String GRAY_SUFFIX = ".gray";
    public static final String NEGATIVE_SUFFIX = ".negative";
    public static final Set<ResourceLocation> ORIGINAL = new HashSet<ResourceLocation>();
    public static final ResourceLocation LEGACY_TEXTURE = Confluence.asResource("hud/icon");
    public static final ResourceLocation OVERLAY_TEXTURE = Confluence.asResource("hud/overlay");
    public static final ResourceLocation ICON_0 = Confluence.asResource("hud/icon_0");
    private static final Set<ResourceLocation> failed = new HashSet<ResourceLocation>();
    public static final int LEGACY_SIZE = 128;
    public static final int OVERLAY_SIZE = 128;

    public static void clearCache() {
        failed.clear();
        ORIGINAL.clear();
    }

    public static ResourceLocation getGrayTexture(ResourceLocation original) {
        if (failed.contains(original)) {
            return original;
        }
        ResourceLocation gray = original.withSuffix(GRAY_SUFFIX);
        if (Minecraft.getInstance().getTextureManager().getTexture(gray, null) == null) {
            try {
                try (InputStream inputstream = Minecraft.getInstance().getResourceManager().getResourceOrThrow(original).open();){
                    DynamicTexture texture = new DynamicTexture(LibClientUtils.copyWithGray((NativeImage)NativeImage.read((InputStream)inputstream)));
                    Minecraft.getInstance().getTextureManager().register(gray, (AbstractTexture)texture);
                }
                return gray;
            }
            catch (IOException ioexception) {
                failed.add(original);
                return original;
            }
        }
        return gray;
    }

    public static void drawString(GuiGraphics guiGraphics, Font font, @Nullable String text, float x, float y, int color) {
        guiGraphics.drawString(font, text, x + 1.0f, y, 0, false);
        guiGraphics.drawString(font, text, x - 1.0f, y, 0, false);
        guiGraphics.drawString(font, text, x, y + 1.0f, 0, false);
        guiGraphics.drawString(font, text, x, y - 1.0f, 0, false);
        guiGraphics.drawString(font, text, x, y, color, false);
    }

    public static void drawColor(GuiGraphics guiGraphics, int x, int y, int iconX, int iconY, ResourceLocation icon, int color, int colorHigh, int colorLow, int size, int part, int partDis) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float redHigh = (float)(colorHigh >> 16 & 0xFF) / 255.0f;
        float greenHigh = (float)(colorHigh >> 8 & 0xFF) / 255.0f;
        float blueHigh = (float)(colorHigh & 0xFF) / 255.0f;
        float redLow = (float)(colorLow >> 16 & 0xFF) / 255.0f;
        float greenLow = (float)(colorLow >> 8 & 0xFF) / 255.0f;
        float blueLow = (float)(colorLow & 0xFF) / 255.0f;
        if (part >= 1) {
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX, iconY, x, y, 9, 9);
        }
        if (part >= 2) {
            RenderSystem.setShaderColor((float)redLow, (float)greenLow, (float)blueLow, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX + partDis, iconY, x, y, 9, 9);
        }
        if (part >= 3) {
            RenderSystem.setShaderColor((float)redHigh, (float)greenHigh, (float)blueHigh, (float)1.0f);
            guiGraphics.blitSprite(icon, size, size, iconX + partDis * 2, iconY, x, y, 9, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static int colorHigh(int color) {
        return color / 255 * 55 + 200;
    }

    public static int colorLow(int color, RandomSource random) {
        int colorT = color - 60 + random.nextInt(121);
        if (colorT < 0) {
            colorT = 0;
        }
        if (colorT > 255) {
            colorT = 255;
        }
        return colorT;
    }

    public static Vector3i color(RandomSource random) {
        int G;
        int R;
        int B;
        do {
            R = random.nextInt(256);
            G = random.nextInt(256);
        } while ((B = random.nextInt(256) + 255 - R - G) > 255 || B < 0);
        int color = R << 16 | G << 8 | B;
        int colorHigh = ClientUtils.colorHigh(R) << 16 | ClientUtils.colorHigh(G) << 8 | ClientUtils.colorHigh(B);
        int colorLow = ClientUtils.colorLow(R, random) << 16 | ClientUtils.colorLow(G, random) << 8 | ClientUtils.colorLow(B, random);
        return new Vector3i(color, colorHigh, colorLow);
    }

    public static void draw(int x, int y, GuiGraphics guiGraphics, int count, int color, int colorHigh, int colorLow, ResourceLocation icon, int size, int uvX, int uvY, boolean left, int part, int partDis) {
        int countT = count / 2;
        int xT = left ? x - 8 : x + 80;
        for (int i = 0; i < countT; ++i) {
            xT = left ? x + i * 8 : x + 72 - i * 8;
            ClientUtils.drawColor(guiGraphics, xT, y, uvX, uvY, icon, color, colorHigh, colorLow, size, part, partDis);
        }
        if (count - countT * 2 == 1) {
            ClientUtils.drawColor(guiGraphics, xT + (left ? 8 : -8), y, uvX + partDis / 2, uvY, icon, color, colorHigh, colorLow, size, part, partDis);
        }
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float max, float current, int x, int y, int size, int uvY, boolean left) {
        ClientUtils.colorDraw(guiGraphics, minecraft, random, texture, COLOR, COLOR_HIGH, COLOR_LOW, max, current, x, y, size, uvY, left, true);
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float current, int x, int y, int size, int uvY, boolean left) {
        ClientUtils.colorDraw(guiGraphics, minecraft, random, texture, COLOR, COLOR_HIGH, COLOR_LOW, 0.0f, current, x, y, size, uvY, left, false);
    }

    public static void colorDraw(GuiGraphics guiGraphics, Minecraft minecraft, RandomSource random, ResourceLocation texture, int[] COLOR, int[] COLOR_HIGH, int[] COLOR_LOW, float max, float current, int x, int y, int size, int uvY, boolean left, boolean background) {
        int lineCount;
        int backCount = (int)(max / 2.0f);
        int heartCount = (int)current;
        if (max / 2.0f > (float)backCount) {
            ++backCount;
        }
        if (current > (float)heartCount) {
            ++heartCount;
        }
        for (int i = 0; i < backCount && i < 10 && background; ++i) {
            guiGraphics.blitSprite(texture, size, size, 60, uvY, x + i * 8 + (backCount < 10 && !left ? (10 - backCount) * 8 : 0), y, 9, 9);
        }
        int lineCountDraw = lineCount = heartCount / 20;
        Vector3i color = new Vector3i(0, 0, 0);
        for (int i = 0; i <= lineCount; ++i) {
            int drawCount;
            Vector3i colorJ = color;
            int n = drawCount = i == lineCount ? heartCount % 20 : 20;
            if (i < Math.min(COLOR.length, Math.min(COLOR_HIGH.length, COLOR_LOW.length))) {
                color = ClientUtils.color(random);
                color.x = COLOR[i];
                if (lineCount - i < 2) {
                    ClientUtils.draw(x, y, guiGraphics, drawCount, COLOR[i], COLOR_HIGH[i], COLOR_LOW[i], texture, size, 0, uvY, left, 3, 20);
                }
            } else {
                color = ClientUtils.color(random);
                if (lineCount - i < 2) {
                    ClientUtils.draw(x, y, guiGraphics, drawCount, color.x, color.y, color.z, texture, size, 0, uvY, left, 3, 20);
                }
            }
            if (drawCount != 20 && drawCount != 0) {
                lineCountDraw = lineCount + 1;
            }
            if (drawCount != 0) continue;
            color = colorJ;
        }
        String drawString = Integer.toString(lineCountDraw);
        if (lineCountDraw > 1) {
            ClientUtils.drawString(guiGraphics, minecraft.font, drawString, left ? (float)(x - 3 - minecraft.font.width((FormattedText)Component.literal((String)drawString))) : (float)(x + 85), y + 1, color.x);
        }
    }

    public static int getVanityDyeARGB(ExtraInventory extraInventory, int index, Player player) {
        ItemStack vanityArmorDye;
        if (index != -1 && !(vanityArmorDye = extraInventory.getVanityArmor(index, true)).isEmpty()) {
            Team team;
            Item item = vanityArmorDye.getItem();
            if (item instanceof BaseDyeItem) {
                return BaseDyeItem.getARGB(vanityArmorDye);
            }
            if (item == VanityArmorItems.TEAM_DYE.get() && (team = TeamManager.getTeam((Entity)player)) != null) {
                return FastColor.ARGB32.opaque((int)team.getRGB());
            }
        }
        return -1;
    }

    public static void livingDeath(LivingEntity entity) {
        block18: {
            Vec3 entityPos;
            float deathSpeed;
            Vec3 deathMotion;
            EntityRenderer renderer;
            ClientLevel level;
            block17: {
                Mob mob;
                Level level2 = entity.level();
                if (!(level2 instanceof ClientLevel)) {
                    return;
                }
                level = (ClientLevel)level2;
                DeathAnimUtils.tellDiscardEntity((Entity)entity);
                renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)entity);
                deathMotion = entity instanceof Mob && (mob = (Mob)entity).isNoAi() ? Vec3.ZERO : IEntity.of((Entity)entity).confluence$deathMotion(new Vec3[0]);
                if (deathMotion == null) {
                    deathMotion = entity.getDeltaMovement();
                }
                deathSpeed = (float)deathMotion.length();
                entityPos = entity.position();
                if (!(entity instanceof GeoAnimatable)) break block17;
                GeoAnimatable animatable = (GeoAnimatable)entity;
                if (!(renderer instanceof GeoEntityRenderer)) break block17;
                GeoEntityRenderer geoRenderer = (GeoEntityRenderer)renderer;
                PoseStack poseStack = new PoseStack();
                BakedGeoModel bakedGeoModel = geoRenderer.getGeoModel().getBakedModel(geoRenderer.getGeoModel().getModelResource(animatable, (GeoRenderer)geoRenderer));
                geoRenderer.preRender(poseStack, (Entity)entity, bakedGeoModel, null, null, false, 1.0f, 0, 0, 0);
                poseStack.mulPose(Axis.XP.rotationDegrees(entity.getXRot()));
                poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot() + 180.0f));
                Matrix4f pose = poseStack.last().pose();
                Collection bones = geoRenderer.getGeoModel().getAnimationProcessor().getRegisteredBones();
                block0: for (GeoBone bone : bones) {
                    GeoBone parent;
                    if (bone.isHidden() || Boolean.TRUE.equals(bone.shouldNeverRender())) continue;
                    Vector3f boneOffset = new Vector3f(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    ArrayList<Vector3f> rots = new ArrayList<Vector3f>();
                    rots.add(new Vector3f(bone.getRotX(), bone.getRotY(), bone.getRotZ()));
                    for (parent = bone.getParent(); parent != null; parent = parent.getParent()) {
                        if (parent.isHidingChildren()) continue block0;
                        rots.add(new Vector3f(parent.getRotX(), parent.getRotY(), parent.getRotZ()));
                        boneOffset.add(parent.getPosX(), parent.getPosY(), parent.getPosZ());
                    }
                    boneOffset.div(16.0f);
                    for (GeoCube cube : bone.getCubes()) {
                        GeoCube copyCube = IGeoCube.of(cube).confluence$getCopy();
                        if (copyCube == null) continue;
                        DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, (Entity)entity, copyCube, deathSpeed);
                        float[] min = IGeoCube.of(copyCube).confluence$getMinCoords();
                        float[] max = IGeoCube.of(copyCube).confluence$getMaxCoords();
                        float xOffset = (min[0] + max[0]) / 2.0f + boneOffset.x;
                        float yOffset = min[1] + boneOffset.y;
                        float zOffset = (min[2] + max[2]) / 2.0f + boneOffset.z;
                        part.boneRots = rots;
                        ArrayList<Vector3f> bonePivots = new ArrayList<Vector3f>();
                        bonePivots.add(new Vector3f(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ()).sub((Vector3fc)new Vector3f(xOffset, yOffset, zOffset).mul(16.0f)).div(16.0f));
                        for (parent = bone.getParent(); parent != null; parent = parent.getParent()) {
                            bonePivots.add(new Vector3f(parent.getPivotX(), parent.getPivotY(), parent.getPivotZ()).sub((Vector3fc)new Vector3f(xOffset, yOffset, zOffset).mul(16.0f)).div(16.0f));
                        }
                        part.bonePivots = bonePivots;
                        part.boneOffset = boneOffset;
                        Vector4f transformed = pose.transform(new Vector4f(xOffset, yOffset, zOffset, 0.0f));
                        part.setPos(entityPos.add((double)transformed.x, (double)transformed.y, (double)transformed.z));
                        part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.5 + 0.2)).multiply(1.0, (double)1.05f, 1.0));
                        DeathAnimUtils.tellAddEntity(level, part);
                    }
                }
                break block18;
            }
            if (!(renderer instanceof LivingEntityRenderer)) break block18;
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            ModelPart rootModelPart = ILivingEntityRenderer.of(livingRenderer).confluence$getRootModelPart();
            if (rootModelPart == null) {
                return;
            }
            AntiPushPoseStack poseStack = new AntiPushPoseStack();
            poseStack.translate(entityPos.x, entityPos.y, entityPos.z);
            DeathAnimUtils.dummyRender(livingRenderer, entity, (PoseStack)poseStack);
            EntityModel entityModel = livingRenderer.getModel();
            if (entityModel instanceof AgeableHierarchicalModel) {
                AgeableHierarchicalModel model = (AgeableHierarchicalModel)entityModel;
                if (model.young) {
                    poseStack.scale(model.youngScaleFactor, model.youngScaleFactor, model.youngScaleFactor);
                    poseStack.translate(0.0f, model.bodyYOffset / 16.0f, 0.0f);
                }
            }
            Stack<Vector3f> rots = new Stack<Vector3f>();
            rots.push(new Vector3f());
            ClientUtils.makePartRecursively(rootModelPart, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, null);
            for (RenderLayer layer : livingRenderer.layers) {
                ResourceLocation texture;
                HumanoidModel outerModel;
                Item model;
                ArmorItem armorItem;
                if (!(layer instanceof HumanoidArmorLayer)) continue;
                HumanoidArmorLayer armorLayer = (HumanoidArmorLayer)layer;
                ItemStack armorItemStack = entity.getItemBySlot(EquipmentSlot.CHEST);
                Item parent = armorItemStack.getItem();
                if (parent instanceof ArmorItem && !((armorItem = (ArmorItem)parent) instanceof GeoItem) && armorItem.getEquipmentSlot() == EquipmentSlot.CHEST && (model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.CHEST, (HumanoidModel)armorLayer.outerModel)) instanceof HumanoidModel) {
                    outerModel = (HumanoidModel)model;
                    outerModel.setAllVisible(true);
                    ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
                    for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                        texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.CHEST);
                        ClientUtils.makePartRecursively(outerModel.body, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                        ClientUtils.makePartRecursively(outerModel.leftArm, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                        ClientUtils.makePartRecursively(outerModel.rightArm, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                    }
                }
                if ((model = (armorItemStack = entity.getItemBySlot(EquipmentSlot.LEGS)).getItem()) instanceof ArmorItem && !((armorItem = (ArmorItem)model) instanceof GeoItem) && armorItem.getEquipmentSlot() == EquipmentSlot.LEGS && (model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.LEGS, (HumanoidModel)armorLayer.innerModel)) instanceof HumanoidModel) {
                    outerModel = (HumanoidModel)model;
                    outerModel.setAllVisible(true);
                    ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
                    for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                        texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)true, (EquipmentSlot)EquipmentSlot.LEGS);
                        ClientUtils.makePartRecursively(outerModel.leftLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                        ClientUtils.makePartRecursively(outerModel.rightLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                    }
                }
                if ((model = (armorItemStack = entity.getItemBySlot(EquipmentSlot.FEET)).getItem()) instanceof ArmorItem && !((armorItem = (ArmorItem)model) instanceof GeoItem) && armorItem.getEquipmentSlot() == EquipmentSlot.FEET && (model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.FEET, (HumanoidModel)armorLayer.outerModel)) instanceof HumanoidModel) {
                    outerModel = (HumanoidModel)model;
                    outerModel.setAllVisible(true);
                    ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
                    for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                        texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.FEET);
                        ClientUtils.makePartRecursively(outerModel.leftLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                        ClientUtils.makePartRecursively(outerModel.rightLeg, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                    }
                }
                if (!((model = (armorItemStack = entity.getItemBySlot(EquipmentSlot.HEAD)).getItem()) instanceof ArmorItem) || (armorItem = (ArmorItem)model) instanceof GeoItem || armorItem.getEquipmentSlot() != EquipmentSlot.HEAD || !((model = ClientHooks.getArmorModel((LivingEntity)entity, (ItemStack)armorItemStack, (EquipmentSlot)EquipmentSlot.HEAD, (HumanoidModel)armorLayer.outerModel)) instanceof HumanoidModel)) continue;
                outerModel = (HumanoidModel)model;
                outerModel.setAllVisible(true);
                ((HumanoidModel)armorLayer.getParentModel()).copyPropertiesTo(outerModel);
                for (ArmorMaterial.Layer materialLayer : ((ArmorMaterial)armorItem.getMaterial().value()).layers()) {
                    texture = ClientHooks.getArmorTexture((Entity)entity, (ItemStack)armorItemStack, (ArmorMaterial.Layer)materialLayer, (boolean)false, (EquipmentSlot)EquipmentSlot.HEAD);
                    ClientUtils.makePartRecursively(outerModel.head, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                    ClientUtils.makePartRecursively(outerModel.hat, poseStack, livingRenderer, level, (Entity)entity, deathSpeed, rots, deathMotion, texture);
                }
            }
        }
    }

    private static void makePartRecursively(ModelPart modelPart, AntiPushPoseStack poseStack, LivingEntityRenderer<?, ?> renderer, ClientLevel level, Entity entity, float deathSpeed, Stack<Vector3f> rots, Vec3 deathMotion, ResourceLocation texture) {
        Object object;
        if (!modelPart.visible || modelPart.skipDraw) {
            return;
        }
        poseStack.pushPose(true);
        if (renderer.getModel().young && (object = renderer.getModel()) instanceof AgeableListModelAccessor) {
            float scale;
            AgeableListModelAccessor model = (AgeableListModelAccessor)object;
            for (ModelPart bodyPart : model.callBodyParts()) {
                if (modelPart != bodyPart) continue;
                scale = 1.0f / model.getBabyBodyScale();
                poseStack.scale(scale, scale, scale);
                poseStack.translate(0.0f, model.getBodyYOffset() / 16.0f, 0.0f);
                break;
            }
            for (ModelPart headPart : model.callHeadParts()) {
                if (modelPart != headPart) continue;
                if (model.getScaleHead()) {
                    scale = 1.5f / model.getBabyHeadScale();
                    poseStack.scale(scale, scale, scale);
                }
                poseStack.translate(0.0f, model.getBabyYHeadOffset() / 16.0f, model.getBabyZHeadOffset() / 16.0f);
                break;
            }
        }
        modelPart.translateAndRotate((PoseStack)poseStack);
        Vector3f modelRot = rots.peek();
        Matrix4f pose = poseStack.last().pose();
        Transformation transformation = new Transformation(pose);
        Vector3f scale = transformation.getScale();
        for (ModelPart.Cube cube : modelPart.cubes) {
            float minX = cube.minX;
            float minY = cube.minY;
            float minZ = cube.minZ;
            float maxX = cube.maxX;
            float maxY = cube.maxY;
            float maxZ = cube.maxZ;
            float centerY = (minY + maxY) / 2.0f / 16.0f;
            float xSize = maxX - minX;
            float ySize = maxY - minY;
            float zSize = maxZ - minZ;
            float min = xSize;
            float finalScale = scale.x;
            if (ySize < min) {
                min = ySize;
                finalScale = scale.y;
            }
            if (zSize < min) {
                min = zSize;
                finalScale = scale.z;
            }
            if ((min /= 16.0f) < 0.0625f) {
                min = 0.0625f;
                finalScale = 1.0f;
            }
            float scaledMin = min * finalScale;
            DeadBodyPartEntity part = new DeadBodyPartEntity((EntityType)ModEntities.BODY_PART.get(), (Level)level, entity, cube, deathSpeed);
            part.texture = texture;
            float xOffset = (minX + maxX) / 2.0f / 16.0f;
            float zOffset = (minZ + maxZ) / 2.0f / 16.0f;
            Vector4f transformedCentroid = pose.transform(new Vector4f(xOffset, centerY, zOffset, 1.0f));
            float yOffset = min / 2.0f - scaledMin / 2.0f;
            Vector4f transformedOffset = pose.transform(new Vector4f(xOffset, centerY, zOffset, 0.0f));
            part.setPos(transformedCentroid.x, transformedCentroid.y - min / 2.0f + yOffset, transformedCentroid.z);
            part.setDeltaMovement(deathMotion.offsetRandom(level.random, (float)(deathMotion.length() * 0.4 + 0.1)));
            if (texture == null) {
                modelRot.add(modelPart.xRot, modelPart.yRot, modelPart.zRot);
            }
            part.modelPartRot = modelRot;
            part.xOffset = transformedOffset.x;
            part.yOffset = transformedOffset.y - scaledMin / 2.0f;
            part.zOffset = transformedOffset.z;
            part.modelPart = modelPart;
            part.minSide = scaledMin;
            DeathAnimUtils.tellAddEntity(level, part);
        }
        for (Map.Entry entry : modelPart.children.entrySet()) {
            String childName = (String)entry.getKey();
            ModelPart child = (ModelPart)entry.getValue();
            if ("cloak".equals(childName)) continue;
            poseStack.pushPose(true);
            Vector3f newRot = new Vector3f((Vector3fc)modelRot);
            rots.push(newRot);
            ClientUtils.makePartRecursively(child, poseStack, renderer, level, entity, deathSpeed, rots, deathMotion, texture);
            rots.pop();
            poseStack.popPose(true);
        }
        poseStack.popPose(true);
    }

    public static <T extends BlockEntity> BlockEntityRendererProvider<T> rendererProvider(Supplier<BlockEntityRenderer<T>> factory) {
        return context -> (BlockEntityRenderer)factory.get();
    }

    public static AABB getRenderBoundingBox3x(BlockPos pos) {
        return new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }

    public static void renderBait(GuiGraphics guiGraphics, ItemStack bait, int x, int y) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)(x + 8), (float)(y + 8), 0.0f);
        pose.scale(0.5f, 0.5f, 0.5f);
        guiGraphics.renderItem(bait, 0, 0);
        pose.popPose();
    }

    public static void renderBoulderSun(Minecraft minecraft) {
        if (ModSecretSeeds.BOULDER_WORLD.match()) {
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockState blockState = ((BoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState();
            PoseStack poseStack = new PoseStack();
            poseStack.mulPose(Axis.ZP.rotation(minecraft.level.getTimeOfDay(0.0f) * ((float)Math.PI * 2)));
            poseStack.translate(-5.0f, 100.0f, -5.0f);
            poseStack.scale(10.0f, 10.0f, 10.0f);
            minecraft.getBlockRenderer().renderSingleBlock(blockState, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY);
        }
    }

    public static void postTheConstantEffect(boolean post) {
        GameRenderer gameRenderer = Minecraft.getInstance().gameRenderer;
        PostChain postChain = gameRenderer.currentEffect();
        if (post) {
            if (postChain == null || !TheConstant.POST_EFFECT.toString().equals(postChain.getName())) {
                gameRenderer.loadEffect(TheConstant.POST_EFFECT);
            }
            gameRenderer.effectActive = true;
        } else if (postChain != null && TheConstant.POST_EFFECT.toString().equals(postChain.getName())) {
            gameRenderer.effectActive = false;
        }
    }
}

