/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.nlf.calendar.Lunar;
import java.util.Calendar;
import java.util.Date;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibDateUtils;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.init.item.FoodItems;
import org.confluence.mod.common.init.item.ModItems;
import org.jetbrains.annotations.ApiStatus;

public final class DateUtils {
    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int _00$00 = LibDateUtils._00$00;
    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int _04$30 = LibDateUtils._04$30;
    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int _06$00 = LibDateUtils._06$00;
    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static final int _19$30 = LibDateUtils._19$30;
    private static long lastCacheTime = 0L;
    private static final Calendar calendar = Calendar.getInstance();
    private static Lunar lunar;

    public static Calendar getCalendar() {
        DateUtils.updateTime();
        return calendar;
    }

    public static Lunar getLunar() {
        DateUtils.updateTime();
        return lunar;
    }

    private static void updateTime() {
        if (System.currentTimeMillis() - lastCacheTime > 86400000L) {
            lastCacheTime = System.currentTimeMillis();
            lunar = null;
        }
        if (lunar == null) {
            calendar.setTimeInMillis(lastCacheTime);
            lunar = new Lunar(new Date(lastCacheTime));
        }
    }

    public static boolean isXinNian(Lunar lunar) {
        return lunar.getMonth() == 1 && lunar.getDay() <= 15;
    }

    public static boolean isQingMing(Lunar lunar) {
        return lunar.getMonth() == 3 && lunar.getDay() >= 7 && lunar.getDay() <= 9;
    }

    public static boolean isDuanWu(Lunar lunar) {
        return lunar.getMonth() == 5 && lunar.getDay() >= 5 && lunar.getDay() <= 7;
    }

    public static boolean isZhongQiu(Lunar lunar) {
        return lunar.getMonth() == 8 && lunar.getDay() == 15;
    }

    public static boolean isHalloween(Calendar calendar) {
        int month = calendar.get(2);
        int date = calendar.get(5);
        return month == 9 && date >= 10 || month == 10 && date == 1;
    }

    public static boolean isChristmas(Calendar calendar) {
        return calendar.get(2) == 11 && calendar.get(5) >= 15;
    }

    public static Item getHolidayGift(RandomSource random) {
        Lunar lunar = DateUtils.getLunar();
        if (DateUtils.isXinNian(lunar)) {
            return (Item)ConsumableItems.RED_ENVELOPE.get();
        }
        if (DateUtils.isDuanWu(lunar)) {
            return random.nextBoolean() ? (Item)FoodItems.ZONGZI.get() : (Item)FoodItems.MEAT_STUFFED_ZONGZI.get();
        }
        if (DateUtils.isZhongQiu(lunar)) {
            return (Item)FoodItems.EGG_YOLK_MOONCAKES.get();
        }
        Calendar calendar = DateUtils.getCalendar();
        if (DateUtils.isHalloween(calendar)) {
            return (Item)ConsumableItems.GOODIE_BAG.get();
        }
        if (DateUtils.isChristmas(calendar)) {
            return (Item)ConsumableItems.CHRISTMAS_GIFT.get();
        }
        return Items.AIR;
    }

    public static Item getHeartItem() {
        Calendar calendar = DateUtils.getCalendar();
        if (DateUtils.isHalloween(calendar)) {
            return (Item)ModItems.CANDY_APPLE.get();
        }
        if (DateUtils.isChristmas(calendar)) {
            return (Item)ModItems.CANDY_CANE.get();
        }
        return (Item)ModItems.HEART.get();
    }

    public static Item getStarItem() {
        Calendar calendar = DateUtils.getCalendar();
        if (DateUtils.isHalloween(calendar)) {
            return (Item)ModItems.SOUL_CAKE.get();
        }
        if (DateUtils.isChristmas(calendar)) {
            return (Item)ModItems.SUGAR_PLUM.get();
        }
        return (Item)ModItems.STAR.get();
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static int getDayTime(Level level) {
        return LibDateUtils.getDayTime((Level)level);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static int getDayTime(long dayTime) {
        return LibDateUtils.getDayTime((long)dayTime);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static int getDayTime(int hour, int minute) {
        return LibDateUtils.getDayTime((int)hour, (int)minute);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean isWithinDayTime(int start, int end, int dayTime) {
        return LibDateUtils.isWithinDayTime((int)start, (int)end, (int)dayTime);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean isWithinDayTime(int startHour, int startMinute, int endHour, int endMinute, int dayTime) {
        return LibDateUtils.isWithinDayTime((int)startHour, (int)startMinute, (int)endHour, (int)endMinute, (int)dayTime);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean isDay(int dayTime) {
        return LibDateUtils.isDay((int)dayTime);
    }

    @Deprecated(since="1.2.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.3.0")
    public static boolean isNight(int dayTime) {
        return LibDateUtils.isNight((int)dayTime);
    }
}

