/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import com.ibm.icu.impl.Pair;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.client.DummyMultiBufferSource;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.integration.geckolib.IGeoCube;
import org.confluence.mod.mixed.IModelPart;
import org.confluence.terraentity.entity.util.DeathAnimOptions;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.GeoCube;
import software.bernie.geckolib.cache.object.GeoQuad;
import software.bernie.geckolib.cache.object.GeoVertex;

public final class DeathAnimUtils {
    public static final Map<EntityType<? extends LivingEntity>, DeathAnimOptions> options = new HashMap<EntityType<? extends LivingEntity>, DeathAnimOptions>();
    public static final List<Pair<ClientLevel, Entity>> toBeAdded = new ArrayList<Pair<ClientLevel, Entity>>();
    public static final List<Entity> toBeDiscarded = new ArrayList<Entity>();

    public static void clear() {
        toBeAdded.clear();
        toBeDiscarded.clear();
    }

    public static void handle() {
        for (Pair<ClientLevel, Entity> pair : toBeAdded) {
            ((ClientLevel)pair.first).addEntity((Entity)pair.second);
        }
        for (Entity entity : toBeDiscarded) {
            entity.discard();
        }
    }

    public static float[] createOffsets(RandomSource random, Vec3 motion, float height, DeathAnimOptions options) {
        Vector3f dir = DeathAnimUtils.createSpread(random, motion);
        float[] rot = options.getRotations();
        return new float[]{dir.x, -height / 16.0f, dir.z, random.nextFloat() * rot[0] * 2.0f - rot[0], random.nextFloat() * rot[1] * 2.0f - rot[1], random.nextFloat() * rot[2] * 2.0f - rot[2]};
    }

    private static Vector3f createSpread(RandomSource random, Vec3 motion) {
        float yRot = random.nextFloat() * 180.0f - 90.0f;
        if (motion.equals((Object)Vec3.ZERO)) {
            motion = Vec3.ZERO.offsetRandom(random, 1.0f);
        }
        float[] rots = VectorUtils.dirToRot((Vec3)motion, (boolean)true);
        rots[0] = rots[0] + yRot;
        return Vec3.directionFromRotation((float)0.0f, (float)rots[0]).normalize().scale(1.2).toVector3f();
    }

    public static float getPosition(int tick, float max) {
        if (tick < 0) {
            tick = 0;
        }
        if (tick > 20) {
            tick = 20;
        }
        float t = (float)tick / 20.0f;
        float p0 = 0.0f;
        float p1 = 1.0f;
        float p2 = 1.0f;
        float p3 = 1.0f;
        float bezierValue = LibUtils.cubicBezier((float)t, (float)p0, (float)p1, (float)p2, (float)p3);
        return bezierValue * max;
    }

    public static ModelPart findRootModelPart(LivingEntityRenderer<?, ?> renderer) {
        EntityModel model = renderer.getModel();
        ModelPart any = DeathAnimUtils.findAnyModelPart(model, model.getClass());
        if (any == null) {
            return null;
        }
        return IModelPart.of(any).confluence$root(new ModelPart[0]);
    }

    public static ModelPart findAnyModelPart(Object model, Class<?> finding) {
        if (model instanceof HierarchicalModel) {
            HierarchicalModel hierarchicalModel = (HierarchicalModel)model;
            return hierarchicalModel.root();
        }
        for (Field field : finding.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(model);
                if (!(object instanceof ModelPart)) continue;
                ModelPart part = (ModelPart)object;
                return part;
            }
            catch (IllegalAccessException | InaccessibleObjectException e) {
                Confluence.LOGGER.error("field.get: ", (Throwable)e);
            }
        }
        if (Model.class.isAssignableFrom(finding.getSuperclass())) {
            return DeathAnimUtils.findAnyModelPart(model, finding.getSuperclass());
        }
        return null;
    }

    public static List<ModelPart> findAllModelPart(LivingEntityRenderer<?, ?> renderer) {
        EntityModel model = renderer.getModel();
        List<ModelPart> ret = DeathAnimUtils.findAllModelPart(model, model.getClass());
        return ret;
    }

    public static List<ModelPart> findAllModelPart(Object model, Class<?> finding) {
        ArrayList<ModelPart> ret = new ArrayList<ModelPart>();
        if (model instanceof HierarchicalModel) {
            HierarchicalModel hierarchicalModel = (HierarchicalModel)model;
            ret.addAll(hierarchicalModel.root().getAllParts().toList());
            return ret;
        }
        for (Field field : finding.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(model);
                if (!(object instanceof IModelPart)) continue;
                IModelPart part = (IModelPart)object;
                ret.addAll(part.confluence$root(new ModelPart[0]).getAllParts().toList());
                break;
            }
            catch (IllegalAccessException | InaccessibleObjectException e) {
                Confluence.LOGGER.error("field.get: ", (Throwable)e);
            }
        }
        if (ret.isEmpty() && Model.class.isAssignableFrom(finding.getSuperclass())) {
            ret.addAll(DeathAnimUtils.findAllModelPart(model, finding.getSuperclass()));
        }
        return ret;
    }

    @Nullable
    public static DeathAnimOptions getDeathAnimOptions(Entity entity) {
        DeathAnimOptions r;
        return entity instanceof DeathAnimOptions ? (r = (DeathAnimOptions)entity) : (entity == null ? null : options.get(entity.getType()));
    }

    public static boolean hasDeathAnimOptions(Entity entity) {
        return DeathAnimUtils.getDeathAnimOptions(entity) != null;
    }

    public static int calcParticleCount(AABB range) {
        double x = range.getXsize() * range.getYsize() * range.getZsize();
        return (int)(85.0 * Math.log(x + 1.0));
    }

    public static GeoCube duplicateGeoCube(GeoCube geoCube) {
        GeoQuad[] quads = geoCube.quads();
        GeoQuad[] newQuads = new GeoQuad[quads.length];
        float[] avCoords = new float[3];
        float[] minCoords = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        float[] maxCoords = new float[]{-3.4028235E38f, -3.4028235E38f, -3.4028235E38f};
        int coordsCount = 0;
        for (GeoQuad quad : quads) {
            if (quad == null) continue;
            GeoVertex[] vertices = quad.vertices();
            GeoVertex[] newVertex = new GeoVertex[vertices.length];
            for (GeoVertex vertex : vertices) {
                Vector3f pos = vertex.position();
                avCoords[0] = avCoords[0] + pos.x;
                avCoords[2] = avCoords[2] + pos.z;
                if (pos.x < minCoords[0]) {
                    minCoords[0] = pos.x;
                }
                if (pos.x > maxCoords[0]) {
                    maxCoords[0] = pos.x;
                }
                if (pos.y < minCoords[1]) {
                    minCoords[1] = pos.y;
                }
                if (pos.y > maxCoords[1]) {
                    maxCoords[1] = pos.y;
                }
                if (pos.z < minCoords[2]) {
                    minCoords[2] = pos.z;
                }
                if (pos.z > maxCoords[2]) {
                    maxCoords[2] = pos.z;
                }
                ++coordsCount;
                newVertex[i] = new GeoVertex(new Vector3f((Vector3fc)pos), vertex.texU(), vertex.texV());
            }
            newQuads[j] = new GeoQuad(newVertex, new Vector3f((Vector3fc)quad.normal()), quad.direction());
        }
        if (coordsCount == 0) {
            return null;
        }
        avCoords[0] = avCoords[0] / (float)coordsCount;
        avCoords[1] = minCoords[1];
        avCoords[2] = avCoords[2] / (float)coordsCount;
        Vec3 offset = new Vec3((double)avCoords[0], (double)avCoords[1], (double)avCoords[2]);
        GeoCube newCube = new GeoCube(newQuads, geoCube.pivot().subtract(offset.scale(16.0)), geoCube.rotation(), geoCube.size(), geoCube.inflate(), geoCube.mirror());
        DeathAnimUtils.moveToOrigin(newCube, offset);
        IGeoCube iGeoCube = IGeoCube.of(newCube);
        iGeoCube.confluence$setMaxCoords(maxCoords);
        iGeoCube.confluence$setMinCoords(minCoords);
        return newCube;
    }

    public static void moveToOrigin(GeoCube cube, Vec3 centroid) {
        for (GeoQuad quad : cube.quads()) {
            if (quad == null) continue;
            for (GeoVertex vertex : quad.vertices()) {
                Vector3f pos = vertex.position();
                pos.set((double)pos.x - centroid.x, (double)pos.y - centroid.y, (double)pos.z - centroid.z);
            }
        }
    }

    public static void tellAddEntity(ClientLevel level, Entity entity) {
        toBeAdded.add((Pair<ClientLevel, Entity>)Pair.of((Object)level, (Object)entity));
    }

    public static void tellDiscardEntity(Entity entity) {
        toBeDiscarded.add(entity);
    }

    public static <T extends LivingEntity> void dummyRender(LivingEntityRenderer<T, ?> livingRenderer, LivingEntity entity, PoseStack poseStack) {
        livingRenderer.render(entity, entity.getYRot(), 1.0f, poseStack, DummyMultiBufferSource.INSTANCE, 0);
    }
}

