/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.util;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.confluence.lib.util.ReturnException;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.mixed.IPalettedContainer;
import org.confluence.mod.util.BlockCounts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicBiomeUtils {
    public static final int BIOME_THRESHOLD = 256;
    public static final Function<BlockState, @Nullable BlockCounts.Type> COUNTER = state -> {
        Block block = state.getBlock();
        if (block == Blocks.SUNFLOWER) {
            return BlockCounts.Type.SUNFLOWER;
        }
        Holder.Reference holder = block.builtInRegistryHolder();
        if (holder.is(ModTags.Blocks.CRIMSON_BLOCKS)) {
            return BlockCounts.Type.CRIMSON;
        }
        if (holder.is(ModTags.Blocks.CRIMSON_DESERT_BLOCKS)) {
            return BlockCounts.Type.CRIMSON_SAND;
        }
        if (holder.is(ModTags.Blocks.CRIMSON_TUNDRA_BLOCKS)) {
            return BlockCounts.Type.CRIMSON_ICE;
        }
        if (holder.is(ModTags.Blocks.CORRUPTION_BLOCKS)) {
            return BlockCounts.Type.CORRUPT;
        }
        if (holder.is(ModTags.Blocks.CORRUPTED_DESERT_BLOCKS)) {
            return BlockCounts.Type.CORRUPT_SAND;
        }
        if (holder.is(ModTags.Blocks.CORRUPTED_TUNDRA_BLOCKS)) {
            return BlockCounts.Type.CORRUPT_ICE;
        }
        if (holder.is(ModTags.Blocks.HALLOW_BLOCKS)) {
            return BlockCounts.Type.HALLOW;
        }
        if (holder.is(ModTags.Blocks.HALLOW_DESERT_BLOCKS)) {
            return BlockCounts.Type.HALLOW_SAND;
        }
        if (holder.is(ModTags.Blocks.HALLOW_TUNDRA_BLOCKS)) {
            return BlockCounts.Type.HALLOW_ICE;
        }
        if (holder.is(ModTags.Blocks.TOMBSTONE)) {
            return BlockCounts.Type.TOMB;
        }
        return null;
    };
    public static final Object2IntMap<ResourceKey<Biome>> PRIORITY = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap<ResourceKey<Biome>>(){
        {
            this.defRetValue = Integer.MAX_VALUE;
        }
    }, map -> {
        map.put(ModBiomes.THE_HALLOW_TUNDRA, 0);
        map.put(ModBiomes.THE_CORRUPTION_TUNDRA, 100);
        map.put(ModBiomes.THE_CRIMSON_TUNDRA, 200);
        map.put(ModBiomes.THE_HALLOW_DESERT, 300);
        map.put(ModBiomes.THE_CORRUPTION_DESERT, 400);
        map.put(ModBiomes.THE_CRIMSON_DESERT, 500);
        map.put(ModBiomes.THE_HALLOW, 600);
        map.put(ModBiomes.THE_CORRUPTION, 700);
        map.put(ModBiomes.THE_CRIMSON, 800);
        map.put(ModBiomes.GLOWING_MUSHROOM, 900);
    });

    @NotNull
    public static PalettedContainer<Holder<Biome>> judgeBackupBiome(LevelChunkSection section, HolderLookup.RegistryLookup<Biome> lookup) {
        PalettedContainer biomes = (PalettedContainer)section.getBiomes();
        AtomicReference pure = new AtomicReference();
        AtomicBoolean hasEvil = new AtomicBoolean(false);
        try {
            biomes.getAll(biome -> {
                if (biome.is(ModTags.Biomes.SPREADABLE)) {
                    hasEvil.set(true);
                } else {
                    pure.set(biome);
                }
                if (pure.get() != null && hasEvil.get()) {
                    throw new ReturnException();
                }
            });
        }
        catch (ReturnException returnException) {
            // empty catch block
        }
        if (hasEvil.get()) {
            if (pure.get() == null) {
                return IPalettedContainer.recreateSingle(biomes, lookup.getOrThrow(Biomes.PLAINS));
            }
            return IPalettedContainer.recreateSingle(biomes, (Holder)pure.get());
        }
        return biomes;
    }

    @Nullable
    public static Holder<Biome> judgeSection(LevelChunkSection section, HolderLookup.RegistryLookup<Biome> lookup) {
        BlockCounts counts = ILevelChunkSection.of(section).confluence$getBlockCounts();
        int sunflower = counts.sunflower.get() * 64;
        int crimson = Math.max(0, counts.crimson.get() - sunflower);
        int corrupt = Math.max(0, counts.corrupt.get() - sunflower);
        int hallow = counts.hallow.get();
        int evil = Math.max(crimson, corrupt);
        crimson -= hallow;
        corrupt -= hallow;
        hallow -= evil;
        if (corrupt >= 256 && corrupt >= crimson) {
            if (counts.corruptSand.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_CORRUPTION_DESERT);
            }
            if (counts.corruptIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_CORRUPTION_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_CORRUPTION);
        }
        if (crimson >= 256) {
            if (counts.crimsonSand.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_CRIMSON_DESERT);
            }
            if (counts.crimsonIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_CRIMSON_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_CRIMSON);
        }
        if (hallow >= 256) {
            if (counts.hallowSand.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(Biomes.DESERT))) {
                return lookup.getOrThrow(ModBiomes.THE_HALLOW_DESERT);
            }
            if (counts.hallowIce.get() >= 256 || section.getBiomes().maybeHas(biomeHolder -> biomeHolder.is(BiomeTags.SPAWNS_SNOW_FOXES))) {
                return lookup.getOrThrow(ModBiomes.THE_HALLOW_TUNDRA);
            }
            return lookup.getOrThrow(ModBiomes.THE_HALLOW);
        }
        return null;
    }

    @Nullable
    public static LevelChunkSection getSection(LevelAccessor level, BlockPos pos) {
        if (level.isOutsideBuildHeight(pos)) {
            return null;
        }
        return level.getChunk(pos).getSection(level.getSectionIndex(pos.getY()));
    }

    @Nullable
    public static ILevelChunkSection getISection(LevelAccessor level, BlockPos pos) {
        return ILevelChunkSection.of(DynamicBiomeUtils.getSection(level, pos));
    }

    public static void applyDynamicBiome(ChunkAccess chunk, HolderLookup.RegistryLookup<Biome> lookup) {
        Holder<Biome> belowBiome = null;
        for (LevelChunkSection section : chunk.getSections()) {
            section.recalcBlockCounts();
            Holder<Biome> currentBiome = DynamicBiomeUtils.judgeSection(section, lookup);
            if (currentBiome != null) {
                ILevelChunkSection.of(section).confluence$setBiomes((PalettedContainerRO<Holder<Biome>>)IPalettedContainer.recreateSingle(section.getBiomes(), currentBiome));
            } else if (belowBiome != null) {
                ILevelChunkSection.of(section).confluence$setBiomes((PalettedContainerRO<Holder<Biome>>)IPalettedContainer.recreateSingle(section.getBiomes(), belowBiome));
            }
            belowBiome = currentBiome;
        }
    }
}

