/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.diana.achievements;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.diana.achievements.Achievement;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.HypixelModApi;
import net.sbo.mod.utils.chat.Chat;
import net.sbo.mod.utils.data.DianaItemsData;
import net.sbo.mod.utils.data.DianaTrackerMayorData;
import net.sbo.mod.utils.data.PartyPlayerStats;
import net.sbo.mod.utils.data.SboDataObject;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.impl.game.WorldChangeEvent;
import net.sbo.mod.utils.events.impl.guis.GuiOpenEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003JM\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u0003J\u001f\u0010 \u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00062\b\b\u0002\u0010\u001f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\r\u0010&\u001a\u00020\u0004\u00a2\u0006\u0004\b&\u0010\u0003J\u0015\u0010)\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020\u00042\u0006\u0010#\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\u0004\u00a2\u0006\u0004\b.\u0010\u0003R#\u00100\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0/8\u0006\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103R&\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0012048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b5\u00101\u001a\u0004\b6\u00103R\"\u00107\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b7\u00108\u001a\u0004\b9\u0010:\"\u0004\b;\u0010\u0016R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010@\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0014\u0010C\u001a\u00020B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010D\u00a8\u0006E"}, d2={"Lnet/sbo/mod/diana/achievements/AchievementManager;", "", "<init>", "()V", "", "init", "", "id", "", "name", "description", "rarity", "previousId", "timeout", "", "hidden", "addAchievement", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;IZ)V", "Lnet/sbo/mod/diana/achievements/Achievement;", "getAchievement", "(I)Lnet/sbo/mod/diana/achievements/Achievement;", "unlockAchievement", "(I)V", "processQueue", "lockById", "Lnet/sbo/mod/utils/data/DianaTrackerMayorData;", "tracker", "trackAchievementsItem", "(Lnet/sbo/mod/utils/data/DianaTrackerMayorData;)V", "trackSince", "magicFind", "chimera", "trackMagicFind", "(IZ)V", "Lnet/sbo/mod/utils/events/impl/guis/GuiOpenEvent;", "event", "trackBeKills", "(Lnet/sbo/mod/utils/events/impl/guis/GuiOpenEvent;)V", "backTrackAchievements", "Lnet/sbo/mod/utils/data/PartyPlayerStats;", "playerInfo", "trackWithCheckPlayer", "(Lnet/sbo/mod/utils/data/PartyPlayerStats;)V", "Lnet/sbo/mod/utils/events/impl/game/WorldChangeEvent;", "checkDaxeEnchants", "(Lnet/sbo/mod/utils/events/impl/game/WorldChangeEvent;)V", "addAllAchievements", "", "rarityColorDict", "Ljava/util/Map;", "getRarityColorDict", "()Ljava/util/Map;", "", "achievements", "getAchievements$SBO", "achievementsUnlocked", "I", "getAchievementsUnlocked", "()I", "setAchievementsUnlocked", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "achievementQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isProcessingQueue", "Ljava/util/concurrent/atomic/AtomicBoolean;", "Lkotlinx/coroutines/CoroutineScope;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "SBO"})
@SourceDebugExtension(value={"SMAP\nAchievementManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AchievementManager.kt\nnet/sbo/mod/diana/achievements/AchievementManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,399:1\n1869#2,2:400\n1740#2,3:404\n216#3,2:402\n*S KotlinDebug\n*F\n+ 1 AchievementManager.kt\nnet/sbo/mod/diana/achievements/AchievementManager\n*L\n252#1:400,2\n236#1:404,3\n57#1:402,2\n*E\n"})
public final class AchievementManager {
    @NotNull
    public static final AchievementManager INSTANCE = new AchievementManager();
    @NotNull
    private static final Map<String, String> rarityColorDict;
    @NotNull
    private static final Map<Integer, Achievement> achievements;
    private static int achievementsUnlocked;
    @NotNull
    private static final ConcurrentLinkedQueue<Integer> achievementQueue;
    @NotNull
    private static final AtomicBoolean isProcessingQueue;
    @NotNull
    private static final CoroutineScope coroutineScope;

    private AchievementManager() {
    }

    @NotNull
    public final Map<String, String> getRarityColorDict() {
        return rarityColorDict;
    }

    @NotNull
    public final Map<Integer, Achievement> getAchievements$SBO() {
        return achievements;
    }

    public final int getAchievementsUnlocked() {
        return achievementsUnlocked;
    }

    public final void setAchievementsUnlocked(int n) {
        achievementsUnlocked = n;
    }

    public final void init() {
        Register.INSTANCE.command("sbolockachievements", new String[0], (Function1<? super String[], Unit>)((Function1)AchievementManager::init$lambda$1));
        Register.INSTANCE.command("sbobacktrackachievements", new String[0], (Function1<? super String[], Unit>)((Function1)AchievementManager::init$lambda$2));
        this.addAllAchievements();
    }

    public final void addAchievement(int id, @NotNull String name, @NotNull String description, @NotNull String rarity, @Nullable Integer previousId, int timeout, boolean hidden) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)rarity, (String)"rarity");
        if (achievements.containsKey(id)) {
            Achievement achievement = achievements.get(id);
            throw new RuntimeException("Duplicate achievement ID detected: " + id + ". Achievement with this ID already exists: " + (achievement != null ? achievement.getName() : null));
        }
        Achievement achievement = new Achievement(id, name, description, rarity, previousId, timeout, hidden);
        achievements.put(id, achievement);
        achievement.loadState();
    }

    public static /* synthetic */ void addAchievement$default(AchievementManager achievementManager, int n, String string, String string2, String string3, Integer n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n2 = null;
        }
        if ((n4 & 0x20) != 0) {
            n3 = 1;
        }
        if ((n4 & 0x40) != 0) {
            bl = false;
        }
        achievementManager.addAchievement(n, string, string2, string3, n2, n3, bl);
    }

    @Nullable
    public final Achievement getAchievement(int id) {
        return achievements.get(id);
    }

    public final void unlockAchievement(int id) {
        if (SboDataObject.achievementsData.getAchievements().get(id) == null) {
            achievementQueue.add(id);
            this.processQueue();
        }
    }

    private final void processQueue() {
        if (isProcessingQueue.compareAndSet(false, true)) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            while (!((Collection)AchievementManager.access$getAchievementQueue$p()).isEmpty()) {
                                Integer id = (Integer)AchievementManager.access$getAchievementQueue$p().poll();
                                Intrinsics.checkNotNull((Object)id);
                                Achievement achievement = AchievementManager.INSTANCE.getAchievement(id);
                                if (achievement == null || achievement.isUnlocked()) continue;
                                if (achievement.getPreviousId() != null) {
                                    Achievement achievement2 = AchievementManager.INSTANCE.getAchievement(achievement.getPreviousId());
                                    Boolean bl = achievement2 != null ? Boxing.boxBoolean((boolean)achievement2.isUnlocked()) : null;
                                    Intrinsics.checkNotNull((Object)bl);
                                    if (!bl.booleanValue()) {
                                        AchievementManager.access$getAchievementQueue$p().add(achievement.getPreviousId());
                                        Boxing.boxBoolean((boolean)AchievementManager.access$getAchievementQueue$p().add(id));
                                        continue;
                                    }
                                }
                                achievement.unlock();
                                Thread.sleep(1000L);
                            }
                            AchievementManager.access$isProcessingQueue$p().set(false);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void lockById(int id) {
        block1: {
            if (SboDataObject.achievementsData.getAchievements().get(id) == null) {
                return;
            }
            Achievement achievement = achievements.get(id);
            if (achievement == null) break block1;
            achievement.lock();
        }
    }

    public final void trackAchievementsItem(@NotNull DianaTrackerMayorData tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (!HypixelModApi.INSTANCE.isOnHypixel()) {
            return;
        }
        DianaItemsData itemsData = tracker.getItems();
        long time = itemsData.getTIME();
        int totalBurrows = itemsData.getTOTAL_BURROWS();
        int totalChimera = itemsData.getCHIMERA() + itemsData.getCHIMERA_LS();
        int daedalusStickCount = itemsData.getDAEDALUS_STICK();
        int chimeraLsCount = itemsData.getCHIMERA_LS();
        if (totalBurrows >= 25000) {
            this.unlockAchievement(22);
        } else if (totalBurrows >= 20000) {
            this.unlockAchievement(21);
        } else if (totalBurrows >= 15000) {
            this.unlockAchievement(20);
        } else if (totalBurrows >= 10000) {
            this.unlockAchievement(19);
        } else if (totalBurrows >= 5000) {
            this.unlockAchievement(18);
        }
        if (time >= 259200000L) {
            this.unlockAchievement(27);
        } else if (time >= 172800000L) {
            this.unlockAchievement(26);
        } else if (time >= 86400000L) {
            this.unlockAchievement(25);
        } else if (time >= 36000000L) {
            this.unlockAchievement(24);
        } else if (time >= 3600000L) {
            this.unlockAchievement(23);
        }
        if (itemsData.getMINOS_RELIC() >= 1) {
            this.unlockAchievement(16);
        }
        if (daedalusStickCount >= 7) {
            this.unlockAchievement(8);
        } else if (daedalusStickCount >= 1) {
            this.unlockAchievement(14);
        }
        if (totalChimera >= 32) {
            this.unlockAchievement(11);
        } else if (totalChimera >= 16) {
            this.unlockAchievement(9);
        } else if (totalChimera >= 1) {
            this.unlockAchievement(12);
        }
        if (chimeraLsCount >= 16) {
            this.unlockAchievement(10);
        } else if (chimeraLsCount >= 1) {
            this.unlockAchievement(13);
        }
        if (time >= 18000000L) {
            double burrows = tracker.getItems().getTOTAL_BURROWS();
            int burrowsPerHour = (int)(burrows / ((double)time / 3600000.0));
            if (burrowsPerHour >= 600) {
                this.unlockAchievement(72);
            } else if (burrowsPerHour >= 500) {
                this.unlockAchievement(71);
            } else if (burrowsPerHour >= 450) {
                this.unlockAchievement(70);
            } else if (burrowsPerHour >= 400) {
                this.unlockAchievement(69);
            } else if (burrowsPerHour >= 350) {
                this.unlockAchievement(68);
            }
        }
        if (daedalusStickCount >= 1 && totalChimera >= 2) {
            this.unlockAchievement(73);
        }
        if (daedalusStickCount >= 1 && itemsData.getMINOS_RELIC() >= 2) {
            this.unlockAchievement(74);
        }
    }

    public final void trackSince() {
        if (!HypixelModApi.INSTANCE.isOnHypixel()) {
            return;
        }
        if (SboDataObject.sboData.getMobsSinceInq() >= 1000) {
            this.unlockAchievement(33);
        } else if (SboDataObject.sboData.getMobsSinceInq() >= 500) {
            this.unlockAchievement(32);
        } else if (SboDataObject.sboData.getMobsSinceInq() >= 250) {
            this.unlockAchievement(31);
        }
        if (SboDataObject.sboData.getInqsSinceChim() >= 100) {
            this.unlockAchievement(37);
        } else if (SboDataObject.sboData.getInqsSinceChim() >= 60) {
            this.unlockAchievement(36);
        } else if (SboDataObject.sboData.getInqsSinceChim() >= 30) {
            this.unlockAchievement(35);
        } else if (SboDataObject.sboData.getInqsSinceChim() >= 15) {
            this.unlockAchievement(34);
        }
        if (SboDataObject.sboData.getMinotaursSinceStick() >= 200) {
            this.unlockAchievement(29);
        }
        if (SboDataObject.sboData.getChampsSinceRelic() >= 3000) {
            this.unlockAchievement(66);
        } else if (SboDataObject.sboData.getChampsSinceRelic() >= 1000) {
            this.unlockAchievement(30);
        }
    }

    public final void trackMagicFind(int magicFind, boolean chimera) {
        if (!HypixelModApi.INSTANCE.isOnHypixel()) {
            return;
        }
        if (magicFind >= 600) {
            this.unlockAchievement(42);
        } else if (magicFind >= 500) {
            this.unlockAchievement(41);
        } else if (magicFind >= 400) {
            this.unlockAchievement(40);
        } else if (magicFind >= 300) {
            this.unlockAchievement(39);
        }
        if (chimera) {
            if (magicFind < 100) {
                this.unlockAchievement(43);
            } else if (magicFind < 200) {
                this.unlockAchievement(44);
            }
        }
    }

    public static /* synthetic */ void trackMagicFind$default(AchievementManager achievementManager, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        achievementManager.trackMagicFind(n, bl);
    }

    public final void trackBeKills(@NotNull GuiOpenEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Helper.INSTANCE.sleep(200L, (Function0<Unit>)((Function0)() -> AchievementManager.trackBeKills$lambda$4(event)));
    }

    public final void backTrackAchievements() {
        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eBacktracking Achievements...");
        Iterable $this$forEach$iv = SboDataObject.pastDianaEventsData.getEvents();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DianaTrackerMayorData eventData = (DianaTrackerMayorData)element$iv;
            boolean bl = false;
            INSTANCE.trackAchievementsItem(eventData);
        }
        this.trackSince();
    }

    public final void trackWithCheckPlayer(@NotNull PartyPlayerStats playerInfo) {
        Intrinsics.checkNotNullParameter((Object)playerInfo, (String)"playerInfo");
        if (playerInfo.getEman9()) {
            this.unlockAchievement(56);
        }
        if (playerInfo.getMythosKills() >= 150000) {
            this.unlockAchievement(61);
        } else if (playerInfo.getMythosKills() >= 100000) {
            this.unlockAchievement(60);
        } else if (playerInfo.getMythosKills() >= 50000) {
            this.unlockAchievement(59);
        } else if (playerInfo.getMythosKills() >= 25000) {
            this.unlockAchievement(58);
        } else if (playerInfo.getMythosKills() >= 10000) {
            this.unlockAchievement(57);
        }
        if (playerInfo.getKillLeaderboard() <= 10) {
            this.unlockAchievement(64);
        } else if (playerInfo.getKillLeaderboard() <= 50) {
            this.unlockAchievement(63);
        } else if (playerInfo.getKillLeaderboard() <= 100) {
            this.unlockAchievement(62);
        }
    }

    public final void checkDaxeEnchants(@NotNull WorldChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Helper.INSTANCE.sleep(2000L, (Function0<Unit>)((Function0)AchievementManager::checkDaxeEnchants$lambda$6));
    }

    public final void addAllAchievements() {
        AchievementManager.addAchievement$default(this, 1, "Back-to-Back Chimera", "Get 2 Chimera in a row", "Mythic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 2, "b2b2b Chimera", "Get 3 Chimera in a row", "Divine", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 66, "Back-to-Back LS Chimera", "Get 2 Lootshare Chimera in a row", "Divine", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 67, "b2b2b LS Chimera", "Get 3 Lootshare Chimera in a row", "Impossible", 66, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 3, "Back-to-Back Stick", "Get 2 Sticks in a row", "Divine", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 5, "Back-to-Back Relic", "Get 2 Relics in a row", "Impossible", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 6, "Inquisitor Double Trouble", "Get 2 Inquisitors in a row", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 7, "b2b2b Inquisitor", "Get 3 Inquisitors in a row", "Divine", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 75, "b2b king", "Get b2b chimera from b2b inquisitor", "Impossible", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 12, "First Chimera", "Get your first Chimera", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 9, "Chimera V", "Get 16 chimera in one event", "Mythic", 12, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 11, "Chimera VI", "Get 32 Chimera in one event", "Divine", 9, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 13, "First lootshare Chimera", "Lootshare your first Chimera", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 10, "Tf?", "Get 16 lootshare Chimera in one event", "Divine", 13, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 14, "First Stick", "Get your first Stick", "Uncommon", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 8, "Can i make a ladder now?", "Get 7 Sticks in one event", "Epic", 14, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 15, "1/6250", "Lootshare a Stick (1/6250)", "Impossible", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 16, "First Relic", "Get your first Relic", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 17, "1/25000", "Lootshare a Relic (1/25000)", "Impossible", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 18, "Where the grind begins", "Get 5k burrows in one event", "Common", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 19, "Touch some grass", "Get 10k burrows in one event", "Uncommon", 18, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 20, "Please go outside", "Get 15k burrows in one event", "Epic", 19, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 21, "Digging your own grave", "Get 20k burrows in one event", "Legendary", 20, 3, false, 64, null);
        AchievementManager.addAchievement$default(this, 22, "Are you mentally stable?", "Get 25k burrows in one event", "Mythic", 21, 4, false, 64, null);
        AchievementManager.addAchievement$default(this, 23, "So this is Diana?", "1 hour of playtime in one event", "Common", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 24, "Is this really fun?", "10 hours of playtime in one event", "Uncommon", 23, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 25, "No shower for me", "1 day of playtime in one event", "Rare", 24, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 26, "Are you okay?", "2 days of playtime in one event", "Epic", 25, 3, false, 64, null);
        AchievementManager.addAchievement$default(this, 27, "Sleep is downtime!", "3 days of playtime in one event", "Legendary", 26, 4, false, 64, null);
        AchievementManager.addAchievement$default(this, 29, "lf Stick", "200 Minotaur since Stick", "Common", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 30, "lf Relic", "1000 Champions since Relic", "Uncommon", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 65, "Where is my Relic?", "3000 champions since Relic", "Mythic", 30, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 31, "lf Inquisitor", "250 mobs since Inquisitor", "Common", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 32, "You have legi Griffin right?", "500 mobs since Inquisitor", "Rare", 31, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 33, "Why do you still play?", "1000 mobs since Inquisitor", "Legendary", 32, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 34, "lf Chimera", "15 Inquisitors since Chimera", "Common", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 35, "So where is my Chimera?", "30 inquisitors since Chimera", "Epic", 34, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 36, "I am done", "60 Inquisitors since Chimera", "Legendary", 35, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 37, "No more Diana", "100 Inquisitors since Chimera", "Divine", 36, 3, false, 64, null);
        AchievementManager.addAchievement$default(this, 38, "Real Diana non", "Download SBO", "Divine", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 39, "Fortune seeker", "Get a Diana drop with 300 Magic Find", "Uncommon", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 40, "Blessed by fortune", "Get a Diana drop with 400 Magic Find", "Epic", 39, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 41, "Greed knows no bounds", "Get a Diana drop with 500 Magic Find", "Mythic", 40, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 42, "The principle of luck", "Get a Diana drop with 600 Magic Find", "Divine", 41, 3, false, 64, null);
        AchievementManager.addAchievement$default(this, 44, "Magic Find is overrated", "Drop a Chimera, under 200 Magic Find", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 43, "I don't need Magic Find", "Drop a Chimera, under 100 Magic Find", "Legendary", 44, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 45, "Inquisitor Slayer", "Max the Inquisitor Bestiary", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 46, "Minotaur Slayer", "Max the Minotaur Bestiary", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 47, "Champion Slayer", "Max the Champion Bestiary", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 48, "Hunter Slayer", "Max the Hunter Bestiary", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 49, "Lynx Slayer", "Max the Siamese Lynx Bestiary", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 50, "Gaia Slayer", "Max the Gaia Bestiary", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 51, "Time to get on the leaderboard", "Max all Diana Bestiaries", "Mythic", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 52, "Daedalus Mastery: Chimera V", "Chimera V on Daedalus Axe", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 53, "Daedalus Mastery: Looting V", "Looting V on Daedalus Axe", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 54, "Daedalus Mastery: Divine Gift III", "Divine Gift III on Daedalus Axe", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 55, "Looking Clean", "Get max Divine Gift, Chimera, Looting", "Mythic", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 56, "Now you can't complain", "Obtain Enderman Slayer 9", "Epic", null, 0, true, 48, null);
        AchievementManager.addAchievement$default(this, 57, "Oh look maxed Crest", "Kill 10k Diana Mobs", "Rare", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 58, "Keep the grind going", "Kill 25k Diana Mobs", "Epic", 57, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 59, "I am not addicted", "Kill 50k Diana Mobs", "Legendary", 58, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 60, "100k gang", "Kill 100k Diana Mobs", "Mythic", 59, 3, false, 64, null);
        this.addAchievement(61, "The grind never stops", "Kill 150k Diana Mobs", "Divine", 60, 4, true);
        AchievementManager.addAchievement$default(this, 62, "Mom look i am on the leaderboard", "Top 100 on the kills leaderboard", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 63, "So this is what addiction feels like", "Top 50 on the kills leaderboard", "Mythic", 62, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 64, "Diana is my life", "Top 10 on the kills leaderboard", "Divine", 63, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 68, "Dedicated Digger", "Get 350 burrows/hour (5h playtime)", "Uncommon", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 69, "Burrow Enthusiast", "Get 400 burrows/hour (5h playtime)", "Epic", 68, 0, false, 96, null);
        AchievementManager.addAchievement$default(this, 70, "Shovel Expert", "Get 450 burrows/hour (5h playtime)", "Legendary", 69, 2, false, 64, null);
        AchievementManager.addAchievement$default(this, 71, "Burrow Maniac", "Get 500 burrows/hour (5h playtime)", "Divine", 70, 3, false, 64, null);
        this.addAchievement(72, "Nice macro!", "Get 600 burrows/hour (5h playtime)", "Impossible", 71, 4, true);
        AchievementManager.addAchievement$default(this, 73, "Can I craft a Chimera sword now?", "Get 1 stick & 2 chimeras in 1 event", "Epic", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 74, "Can I craft a Relic sword now?", "Get 1 stick & 2 relics in 1 event", "Legendary", null, 0, false, 112, null);
        AchievementManager.addAchievement$default(this, 77, "From the ashes", "Drop a Phoenix pet from a Diana mob", "Impossible", null, 0, true, 48, null);
    }

    private static final Unit init$lambda$1(String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!Intrinsics.areEqual((Object)ArraysKt.getOrNull((Object[])args, (int)0), (Object)"CONFIRM")) {
            Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eYou are about to reset all your achievements. Type \u00a7c/sbolockachievements CONFIRM \u00a7eto confirm");
            return Unit.INSTANCE;
        }
        Map<Integer, Achievement> $this$forEach$iv = achievements;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, Achievement>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Achievement> element$iv;
            Map.Entry<Integer, Achievement> entry = element$iv = iterator.next();
            boolean bl = false;
            Achievement achievement = entry.getValue();
            if (!achievement.isUnlocked() || achievement.getId() == 38) continue;
            achievement.lock();
        }
        SboDataObject.INSTANCE.save("AchievementsData");
        Chat.INSTANCE.chat("\u00a76[SBO] \u00a7eAchievements locked");
        return Unit.INSTANCE;
    }

    private static final Unit init$lambda$2(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.backTrackAchievements();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit trackBeKills$lambda$4(GuiOpenEvent $event) {
        boolean allMaxed;
        block17: {
            void $this$all$iv;
            class_437 screen = $event.getScreen();
            if (!(screen instanceof class_465)) {
                return Unit.INSTANCE;
            }
            String string = ((class_465)$event.getScreen()).method_25440().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            if (!StringsKt.contains((CharSequence)string, (CharSequence)"Mythological Creatur", (boolean)true)) {
                return Unit.INSTANCE;
            }
            class_2371 slots = ((class_465)screen).method_17577().field_7761;
            int gaiaKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(10)).method_7677());
            int champKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(11)).method_7677());
            int hunterKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(12)).method_7677());
            int inqKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(13)).method_7677());
            int minoKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(14)).method_7677());
            int catKills = Helper.INSTANCE.getKillsFromLore(((class_1735)slots.get(15)).method_7677());
            Object object = new Pair[]{TuplesKt.to((Object)gaiaKills, (Object)50), TuplesKt.to((Object)inqKills, (Object)45), TuplesKt.to((Object)minoKills, (Object)46), TuplesKt.to((Object)champKills, (Object)47), TuplesKt.to((Object)hunterKills, (Object)48), TuplesKt.to((Object)catKills, (Object)49)};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v1 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean isMaxed;
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    int kills = ((Number)pair.component1()).intValue();
                    int id = ((Number)pair.component2()).intValue();
                    switch (id) {
                        case 45: {
                            boolean bl2;
                            if (kills >= 500) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case 46: 
                        case 49: 
                        case 50: {
                            boolean bl2;
                            if (kills >= 3000) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        case 47: 
                        case 48: {
                            boolean bl2;
                            if (kills >= 1000) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        default: {
                            boolean bl2 = isMaxed = false;
                        }
                    }
                    if (isMaxed) {
                        INSTANCE.unlockAchievement(id);
                    } else {
                        INSTANCE.lockById(id);
                    }
                    if (isMaxed) continue;
                    v1 = false;
                    break block17;
                }
                v1 = allMaxed = true;
            }
        }
        if (allMaxed) {
            INSTANCE.unlockAchievement(51);
        } else {
            INSTANCE.lockById(51);
        }
        return Unit.INSTANCE;
    }

    private static final Unit checkDaxeEnchants$lambda$6() {
        boolean chimV = false;
        boolean lootingV = false;
        boolean divineGift3 = false;
        class_746 class_7462 = SBOKotlin.mc.field_1724;
        if (class_7462 == null) {
            return Unit.INSTANCE;
        }
        class_746 player = class_7462;
        for (int slot = 0; slot < 9; ++slot) {
            class_2487 enchants;
            class_2487 nbt;
            String displayName;
            class_1799 stack;
            Intrinsics.checkNotNullExpressionValue((Object)player.method_31548().method_5438(slot), (String)"getStack(...)");
            if (stack.method_7960()) continue;
            String string = stack.method_7964().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)displayName, (CharSequence)"daedalus", (boolean)false, (int)2, null)) continue;
            Object object = stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
            class_9279 customData = (class_9279)object;
            Intrinsics.checkNotNullExpressionValue((Object)customData.method_57461(), (String)"copyNbt(...)");
            Intrinsics.checkNotNullExpressionValue((Object)nbt.method_10562("enchantments").orElse(new class_2487()), (String)"orElse(...)");
            if (enchants.method_33133()) continue;
            Integer n = enchants.method_10550("ultimate_chimera").orElse(0);
            int n2 = 5;
            if (n != null && n == n2) {
                chimV = true;
            }
            Integer n3 = enchants.method_10550("looting").orElse(0);
            n2 = 5;
            if (n3 != null && n3 == n2) {
                lootingV = true;
            }
            Integer n4 = enchants.method_10550("divine_gift").orElse(0);
            n2 = 3;
            if (n4 == null || n4 != n2) break;
            divineGift3 = true;
            break;
        }
        if (chimV) {
            INSTANCE.unlockAchievement(52);
        }
        if (lootingV) {
            INSTANCE.unlockAchievement(53);
        }
        if (divineGift3) {
            INSTANCE.unlockAchievement(54);
        }
        if (chimV && lootingV && divineGift3) {
            INSTANCE.unlockAchievement(55);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getAchievementQueue$p() {
        return achievementQueue;
    }

    public static final /* synthetic */ AtomicBoolean access$isProcessingQueue$p() {
        return isProcessingQueue;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Common", (Object)"\u00a7f"), TuplesKt.to((Object)"Uncommon", (Object)"\u00a7a"), TuplesKt.to((Object)"Rare", (Object)"\u00a79"), TuplesKt.to((Object)"Epic", (Object)"\u00a75"), TuplesKt.to((Object)"Legendary", (Object)"\u00a76"), TuplesKt.to((Object)"Mythic", (Object)"\u00a7d"), TuplesKt.to((Object)"Divine", (Object)"\u00a7b"), TuplesKt.to((Object)"Impossible", (Object)"\u00a74")};
        rarityColorDict = MapsKt.mapOf((Pair[])pairArray);
        achievements = new LinkedHashMap();
        achievementQueue = new ConcurrentLinkedQueue();
        isProcessingQueue = new AtomicBoolean(false);
        coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    }
}

