/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.render;

import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import net.minecraft.class_9974;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.settings.categories.Customization;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.utils.math.SboVec;
import net.sbo.mod.utils.render.SboRenderLayers;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J]\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017JM\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJM\u0010\"\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\"\u0010#J?\u0010%\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b%\u0010&J1\u0010*\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b*\u0010+JA\u0010\u0014\u001a\u00020\u00152\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u000e2\u0006\u00102\u001a\u0002012\u0006\u0010\u001f\u001a\u00020\f2\b\b\u0002\u0010)\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u00103Jw\u0010?\u001a\u00020\u00152\u0006\u0010-\u001a\u00020,2\u0006\u0010/\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\f2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b?\u0010@JW\u0010C\u001a\u00020\u00152\u0006\u0010B\u001a\u00020A2\u0006\u0010/\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\f2\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u000e2\u0006\u0010>\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bC\u0010DJO\u0010J\u001a\u00020\u00152\u0006\u0010B\u001a\u00020A2\u0006\u0010/\u001a\u0002042\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010E\u001a\u00020\f2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u000e2\u0006\u0010H\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\bJ\u0010KJ!\u0010N\u001a\u00020\u0015*\u00020,2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00150LH\u0002\u00a2\u0006\u0004\bN\u0010O\u00a8\u0006P"}, d2={"Lnet/sbo/mod/utils/render/RenderUtils3D;", "", "<init>", "()V", "Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;", "context", "", "text", "Lnet/sbo/mod/utils/math/SboVec;", "pos", "", "colorComponents", "", "hexColor", "", "alpha", "", "throughWalls", "drawLine", "lineWidth", "renderBeam", "", "renderWaypoint", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Ljava/lang/String;Lnet/sbo/mod/utils/math/SboVec;[FIFZZFZ)V", "", "width", "height", "depth", "drawFilledBox", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;DDD[FFZ)V", "yOffset", "color", "shadow", "scale", "drawString", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;DLjava/lang/String;IZDZ)V", "target", "drawLineFromCursor", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;[FFZF)V", "ctx", "vec", "phase", "renderBeaconBeam", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lnet/sbo/mod/utils/math/SboVec;[FZ)V", "Lnet/minecraft/class_4587;", "matricies", "Lnet/minecraft/class_4597;", "vertices", "partialTicks", "", "worldTime", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_4597;FJIZ)V", "Lnet/minecraft/class_4588;", "x1", "z1", "x2", "z2", "x3", "z3", "x4", "z4", "v1", "v2", "renderBeamLayer", "(Lnet/minecraft/class_4587;Lnet/minecraft/class_4588;IFFFFFFFFFF)V", "Lnet/minecraft/class_4587$class_4665;", "matrix", "renderBeamFace", "(Lnet/minecraft/class_4587$class_4665;Lnet/minecraft/class_4588;IFFFFFF)V", "y", "x", "z", "u", "v", "renderBeamVertex", "(Lnet/minecraft/class_4587$class_4665;Lnet/minecraft/class_4588;IIFFFF)V", "Lkotlin/Function0;", "function", "pushPop", "(Lnet/minecraft/class_4587;Lkotlin/jvm/functions/Function0;)V", "SBO"})
public final class RenderUtils3D {
    @NotNull
    public static final RenderUtils3D INSTANCE = new RenderUtils3D();

    private RenderUtils3D() {
    }

    public final void renderWaypoint(@NotNull WorldRenderContext context, @NotNull String text, @NotNull SboVec pos, @NotNull float[] colorComponents, int hexColor, float alpha, boolean throughWalls, boolean drawLine, float lineWidth, boolean renderBeam) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        this.drawFilledBox(context, pos, 1.0, 1.0, 1.0, colorComponents, alpha, throughWalls);
        if (drawLine) {
            this.drawLineFromCursor(context, pos, colorComponents, lineWidth, throughWalls, alpha);
        }
        if (renderBeam) {
            this.renderBeaconBeam(context, pos, colorComponents, true);
        }
        if (((CharSequence)text).length() > 0 && !Intrinsics.areEqual((Object)text, (Object)"\u00a77")) {
            this.drawString(context, pos, 1.5, text, hexColor, Customization.INSTANCE.getWaypointTextShadow(), (double)Customization.INSTANCE.getWaypointTextScale() / 100.0, throughWalls);
        }
    }

    public final void drawFilledBox(@NotNull WorldRenderContext context, @NotNull SboVec pos, double width, double height, double depth, @NotNull float[] colorComponents, float alpha, boolean throughWalls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        class_4587 matrices = context.matrixStack();
        class_243 cameraPos = context.camera().method_19326();
        class_4587 class_45872 = matrices;
        Intrinsics.checkNotNull((Object)class_45872);
        class_45872.method_22903();
        matrices.method_22904(pos.getX() + 0.5 - cameraPos.field_1352, pos.getY() - cameraPos.field_1351, pos.getZ() + 0.5 - cameraPos.field_1350);
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_1921.class_4687 renderLayer = throughWalls ? SboRenderLayers.FILLED_BOX_THROUGH_WALLS : SboRenderLayers.FILLED_BOX;
        class_4588 buffer = consumers.getBuffer((class_1921)renderLayer);
        double minX = -width / 2.0;
        double minZ = -depth / 2.0;
        double maxX = width / 2.0;
        double maxZ = depth / 2.0;
        double minY = 0.0;
        double maxY = height;
        class_9974.method_62300((class_4587)matrices, (class_4588)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2], (float)alpha);
        matrices.method_22909();
    }

    public final void drawString(@NotNull WorldRenderContext context, @NotNull SboVec pos, double yOffset, @NotNull String text, int color, boolean shadow, double scale, boolean throughWalls) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        class_4587 matrices = context.matrixStack();
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        float cameraYaw = camera.method_19330();
        float cameraPitch = camera.method_19329();
        class_327 textRenderer = SBOKotlin.mc.field_1772;
        class_4587 class_45872 = matrices;
        Intrinsics.checkNotNull((Object)class_45872);
        class_45872.method_22903();
        class_243 textWorldPos = new class_243(pos.getX() + 0.5, pos.getY() + 0.5, pos.getZ() + 0.5);
        double distance = cameraPos.method_1022(textWorldPos);
        double dynamicScale = Math.max(distance, 2.5) * scale;
        matrices.method_22904(pos.getX() + 0.5 - cameraPos.field_1352, pos.getY() + yOffset + -cameraPos.field_1351, pos.getZ() + 0.5 - cameraPos.field_1350);
        matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-cameraYaw));
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(cameraPitch));
        matrices.method_22905(-((float)dynamicScale), -((float)dynamicScale), (float)dynamicScale);
        int textWidth = textRenderer.method_1727(text);
        float xOffset = (float)(-textWidth) / 2.0f;
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_327.class_6415 layerType = throughWalls ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993;
        textRenderer.method_27521(text, xOffset, 0.0f, color, shadow, matrices.method_23760().method_23761(), consumers, layerType, 0, 0xF000F0);
        matrices.method_22909();
    }

    public final void drawLineFromCursor(@NotNull WorldRenderContext context, @NotNull SboVec target, @NotNull float[] color, float lineWidth, boolean throughWalls, float alpha) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        class_4184 camera = context.camera();
        class_243 cameraPos = camera.method_19326();
        class_4587 class_45872 = context.matrixStack();
        Intrinsics.checkNotNull((Object)class_45872);
        class_4587 matrices = class_45872;
        matrices.method_22903();
        matrices.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4597 class_45972 = context.consumers();
        Intrinsics.checkNotNull((Object)class_45972);
        class_4597 consumers = class_45972;
        class_243 startPos = cameraPos.method_1019(class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330()));
        class_243 endPos = target.center().toVec3d().method_1031(0.0, 0.5, 0.0);
        class_243 lineDir = endPos.method_1020(startPos);
        class_243 viewDir = startPos.method_1020(cameraPos);
        class_243 sideVec = lineDir.method_1036(viewDir).method_1029();
        class_243 upVec = sideVec.method_1036(lineDir).method_1029();
        float nx = (float)upVec.field_1352;
        float ny = (float)upVec.field_1351;
        float nz = (float)upVec.field_1350;
        class_1921 renderLayer = SboRenderLayers.INSTANCE.getLines(lineWidth, throughWalls);
        class_4588 buffer = consumers.getBuffer(renderLayer);
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        buffer.method_56824(matrixEntry, (float)startPos.field_1352, (float)startPos.field_1351, (float)startPos.field_1350).method_60831(matrixEntry, nx, ny, nz).method_22915(color[0], color[1], color[2], alpha);
        buffer.method_56824(matrixEntry, (float)endPos.field_1352, (float)endPos.field_1351, (float)endPos.field_1350).method_60831(matrixEntry, nx, ny, nz).method_22915(color[0], color[1], color[2], alpha);
        matrices.method_22909();
    }

    public static /* synthetic */ void drawLineFromCursor$default(RenderUtils3D renderUtils3D, WorldRenderContext worldRenderContext, SboVec sboVec, float[] fArray, float f, boolean bl, float f2, int n, Object object) {
        if ((n & 0x20) != 0) {
            f2 = 0.5f;
        }
        renderUtils3D.drawLineFromCursor(worldRenderContext, sboVec, fArray, f, bl, f2);
    }

    @JvmOverloads
    public final void renderBeaconBeam(@NotNull WorldRenderContext ctx, @NotNull SboVec vec, @NotNull float[] colorComponents, boolean phase) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        class_746 class_7462 = SBOKotlin.mc.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        if (vec.center().distanceTo(player.method_23317(), player.method_23318(), player.method_23321()) < (double)Diana.INSTANCE.getRemoveBeam()) {
            return;
        }
        class_4597 consumers = ctx.consumers();
        class_4587 class_45872 = ctx.matrixStack();
        if (class_45872 == null) {
            return;
        }
        class_4587 matrices = class_45872;
        class_638 class_6382 = SBOKotlin.mc.field_1687;
        if (class_6382 == null) {
            return;
        }
        class_638 wolrd = class_6382;
        float partialTicks = ctx.tickCounter().method_60637(true);
        class_243 cam = ctx.camera().method_19326();
        float[] fArray = new float[]{colorComponents[0], colorComponents[1], colorComponents[2], 1.0f};
        float[] beamColor = fArray;
        this.pushPop(matrices, (Function0<Unit>)((Function0)() -> RenderUtils3D.renderBeaconBeam$lambda$0(matrices, vec, cam, consumers, partialTicks, wolrd, beamColor, phase)));
    }

    public static /* synthetic */ void renderBeaconBeam$default(RenderUtils3D renderUtils3D, WorldRenderContext worldRenderContext, SboVec sboVec, float[] fArray, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        renderUtils3D.renderBeaconBeam(worldRenderContext, sboVec, fArray, bl);
    }

    private final void renderBeam(class_4587 matricies, class_4597 vertices, float partialTicks, long worldTime, int color, boolean phase) {
        class_1921 opaqueLayyer = phase ? SboRenderLayers.INSTANCE.getBEACON_BEAM_OPAQUE_THROUGH_WALLS() : SboRenderLayers.INSTANCE.getBEACON_BEAM_OPAQUE();
        class_1921 transluscentLayer = phase ? SboRenderLayers.INSTANCE.getBEACON_BEAM_TRANSLUCENT_THROUGH_WALLS() : SboRenderLayers.INSTANCE.getBEACON_BEAM_TRANSLUCENT();
        float heightScale = 1.0f;
        int height = 320;
        float innerRadius = 0.2f;
        float outerRadius = 0.25f;
        float time = (float)Math.floorMod(worldTime, 40) + partialTicks;
        float fixedTime = -time;
        float wavePhase = class_3532.method_22450((float)(fixedTime * 0.2f - (float)class_3532.method_15375((float)(fixedTime * 0.1f))));
        float animationStep = -1.0f + wavePhase;
        Ref.FloatRef renderYOffest = new Ref.FloatRef();
        renderYOffest.element = (float)height * heightScale * (0.5f / innerRadius) + animationStep;
        this.pushPop(matricies, (Function0<Unit>)((Function0)() -> RenderUtils3D.renderBeam$lambda$2(matricies, renderYOffest, height, heightScale, animationStep, vertices, transluscentLayer, color, outerRadius, time, opaqueLayyer, innerRadius)));
    }

    static /* synthetic */ void renderBeam$default(RenderUtils3D renderUtils3D, class_4587 class_45872, class_4597 class_45972, float f, long l, int n, boolean bl, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        renderUtils3D.renderBeam(class_45872, class_45972, f, l, n, bl);
    }

    private final void renderBeamLayer(class_4587 matricies, class_4588 vertices, int color, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float v1, float v2) {
        class_4587.class_4665 entry = matricies.method_23760();
        Intrinsics.checkNotNull((Object)entry);
        this.renderBeamFace(entry, vertices, color, x1, z1, x2, z2, v1, v2);
        this.renderBeamFace(entry, vertices, color, x4, z4, x3, z3, v1, v2);
        this.renderBeamFace(entry, vertices, color, x2, z2, x4, z4, v1, v2);
        this.renderBeamFace(entry, vertices, color, x3, z3, x1, z1, v1, v2);
    }

    private final void renderBeamFace(class_4587.class_4665 matrix, class_4588 vertices, int color, float x1, float z1, float x2, float z2, float v1, float v2) {
        this.renderBeamVertex(matrix, vertices, color, 320, x1, z1, 1.0f, v1);
        this.renderBeamVertex(matrix, vertices, color, 0, x1, z1, 1.0f, v2);
        this.renderBeamVertex(matrix, vertices, color, 0, x2, z2, 0.0f, v2);
        this.renderBeamVertex(matrix, vertices, color, 320, x2, z2, 0.0f, v1);
    }

    private final void renderBeamVertex(class_4587.class_4665 matrix, class_4588 vertices, int color, int y, float x, float z, float u, float v) {
        vertices.method_56824(matrix, x, (float)y, z).method_39415(color).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(matrix, 0.0f, 1.0f, 0.0f);
    }

    private final void pushPop(class_4587 $this$pushPop, Function0<Unit> function) {
        $this$pushPop.method_22903();
        function.invoke();
        $this$pushPop.method_22909();
    }

    @JvmOverloads
    public final void renderBeaconBeam(@NotNull WorldRenderContext ctx, @NotNull SboVec vec, @NotNull float[] colorComponents) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Intrinsics.checkNotNullParameter((Object)colorComponents, (String)"colorComponents");
        RenderUtils3D.renderBeaconBeam$default(this, ctx, vec, colorComponents, false, 8, null);
    }

    private static final Unit renderBeaconBeam$lambda$0(class_4587 $matrices, SboVec $vec, class_243 $cam, class_4597 $consumers, float $partialTicks, class_638 $wolrd, float[] $beamColor, boolean $phase) {
        $matrices.method_22904($vec.getX() - $cam.field_1352, $vec.getY() + 1.0 - $cam.field_1351, $vec.getZ() - $cam.field_1350);
        class_4597 class_45972 = $consumers;
        Intrinsics.checkNotNull((Object)class_45972);
        INSTANCE.renderBeam($matrices, class_45972, $partialTicks, $wolrd.method_8510(), new Color($beamColor[0], $beamColor[1], $beamColor[2]).getRGB(), $phase);
        return Unit.INSTANCE;
    }

    private static final Unit renderBeam$lambda$2$lambda$1(class_4587 $matricies, float $time, class_4597 $vertices, class_1921 $opaqueLayyer, int $color, float $innerRadius, Ref.FloatRef $renderYOffest, float $animationStep) {
        $matricies.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees($time * 2.25f - 45.0f));
        class_4588 class_45882 = $vertices.getBuffer($opaqueLayyer);
        Intrinsics.checkNotNullExpressionValue((Object)class_45882, (String)"getBuffer(...)");
        INSTANCE.renderBeamLayer($matricies, class_45882, $color, 0.0f, $innerRadius, $innerRadius, 0.0f, -$innerRadius, 0.0f, 0.0f, -$innerRadius, $renderYOffest.element, $animationStep);
        return Unit.INSTANCE;
    }

    private static final Unit renderBeam$lambda$2(class_4587 $matricies, Ref.FloatRef $renderYOffest, int $height, float $heightScale, float $animationStep, class_4597 $vertices, class_1921 $transluscentLayer, int $color, float $outerRadius, float $time, class_1921 $opaqueLayyer, float $innerRadius) {
        $matricies.method_22904(0.5, 0.0, 0.5);
        INSTANCE.pushPop($matricies, (Function0<Unit>)((Function0)() -> RenderUtils3D.renderBeam$lambda$2$lambda$1($matricies, $time, $vertices, $opaqueLayyer, $color, $innerRadius, $renderYOffest, $animationStep)));
        $renderYOffest.element = (float)$height * $heightScale + $animationStep;
        class_4588 class_45882 = $vertices.getBuffer($transluscentLayer);
        Intrinsics.checkNotNullExpressionValue((Object)class_45882, (String)"getBuffer(...)");
        INSTANCE.renderBeamLayer($matricies, class_45882, class_9848.method_61330((int)32, (int)$color), -$outerRadius, -$outerRadius, $outerRadius, -$outerRadius, -$outerRadius, $outerRadius, $outerRadius, $outerRadius, $renderYOffest.element, $animationStep);
        return Unit.INSTANCE;
    }
}

