/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.diana;

import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import net.sbo.mod.SBOKotlin;
import net.sbo.mod.settings.categories.Customization;
import net.sbo.mod.settings.categories.Diana;
import net.sbo.mod.utils.Helper;
import net.sbo.mod.utils.Player;
import net.sbo.mod.utils.SoundHandler;
import net.sbo.mod.utils.chat.Chat;
import net.sbo.mod.utils.chat.ChatUtils;
import net.sbo.mod.utils.events.Register;
import net.sbo.mod.utils.events.SBOEvent;
import net.sbo.mod.utils.events.impl.entity.DianaMobDeathEvent;
import net.sbo.mod.utils.events.impl.entity.EntityLoadEvent;
import net.sbo.mod.utils.events.impl.entity.EntityUnloadEvent;
import net.sbo.mod.utils.math.SboVec;
import net.sbo.mod.utils.overlay.Overlay;
import net.sbo.mod.utils.overlay.OverlayExamples;
import net.sbo.mod.utils.overlay.OverlayTextLine;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J!\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0003R \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00120\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lnet/sbo/mod/diana/DianaMobDetect;", "", "<init>", "()V", "", "init", "Lnet/sbo/mod/utils/events/impl/entity/EntityLoadEvent;", "event", "onEntityLoad", "(Lnet/sbo/mod/utils/events/impl/entity/EntityLoadEvent;)V", "Lnet/sbo/mod/utils/events/impl/entity/EntityUnloadEvent;", "onEntityUnload", "(Lnet/sbo/mod/utils/events/impl/entity/EntityUnloadEvent;)V", "", "name", "", "extractHealth", "(Ljava/lang/String;)Ljava/lang/Double;", "Lnet/minecraft/class_1531;", "entity", "", "id", "Lnet/sbo/mod/utils/overlay/OverlayTextLine;", "checkDianaMob", "(Lnet/minecraft/class_1531;I)Lnet/sbo/mod/utils/overlay/OverlayTextLine;", "", "checkCocoon", "(Lnet/minecraft/class_1531;)Z", "onInqSpawn", "", "tracked", "Ljava/util/Map;", "", "defeated", "Ljava/util/Set;", "Lnet/sbo/mod/utils/overlay/Overlay;", "mobHpOverlay", "Lnet/sbo/mod/utils/overlay/Overlay;", "SBO"})
public final class DianaMobDetect {
    @NotNull
    public static final DianaMobDetect INSTANCE = new DianaMobDetect();
    @NotNull
    private static final Map<Integer, class_1531> tracked = new LinkedHashMap();
    @NotNull
    private static final Set<Integer> defeated = new LinkedHashSet();
    @NotNull
    private static final Overlay mobHpOverlay = new Overlay("mythosMobHp", 10.0f, 10.0f, 1.0f, CollectionsKt.listOf((Object)"Chat screen"), OverlayExamples.INSTANCE.getMythosMobHpExample()).setCondition((Function0<Boolean>)((Function0)DianaMobDetect::mobHpOverlay$lambda$0));

    private DianaMobDetect() {
    }

    public final void init() {
        mobHpOverlay.init();
        Register.INSTANCE.onTick(1, (Function1<? super Function0<Unit>, Unit>)((Function1)DianaMobDetect::init$lambda$1));
    }

    public final void onEntityLoad(@NotNull EntityLoadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof class_1531) {
            tracked.put(((class_1531)event.getEntity()).method_5628(), (class_1531)event.getEntity());
        }
    }

    public final void onEntityUnload(@NotNull EntityUnloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getEntity() instanceof class_1531) {
            tracked.remove(((class_1531)event.getEntity()).method_5628());
            defeated.remove(((class_1531)event.getEntity()).method_5628());
        }
    }

    private final Double extractHealth(String name) {
        Double d;
        Regex regex = new Regex("([0-9]+(?:\\.[0-9]+)?[MK]?)\u00a7f/");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)name, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        String value = (String)match.getGroupValues().get(1);
        if (StringsKt.endsWith$default((String)value, (String)"M", (boolean)false, (int)2, null)) {
            Double d2 = StringsKt.toDoubleOrNull((String)StringsKt.dropLast((String)value, (int)1));
            d = d2 != null ? Double.valueOf(d2 * (double)1000000) : null;
        } else if (StringsKt.endsWith$default((String)value, (String)"K", (boolean)false, (int)2, null)) {
            Double d3 = StringsKt.toDoubleOrNull((String)StringsKt.dropLast((String)value, (int)1));
            d = d3 != null ? Double.valueOf(d3 * (double)1000) : null;
        } else {
            d = StringsKt.toDoubleOrNull((String)value);
        }
        return d;
    }

    private final OverlayTextLine checkDianaMob(class_1531 entity, int id) {
        Object name;
        Object object = entity.method_5797();
        if (object == null || (object = ChatUtils.INSTANCE.formattedString((class_2561)object)) == null) {
            class_2561 class_25612 = entity.method_5477();
            Intrinsics.checkNotNullExpressionValue((Object)class_25612, (String)"getName(...)");
            object = ChatUtils.INSTANCE.formattedString(class_25612);
        }
        if (((CharSequence)(name = object)).length() == 0 || Intrinsics.areEqual((Object)name, (Object)"Armor Stand")) {
            return null;
        }
        if (StringsKt.contains((CharSequence)((CharSequence)name), (CharSequence)"\u00a72\u273f", (boolean)true)) {
            Double health = this.extractHealth((String)name);
            if (health != null && health <= 0.0 && !defeated.contains(id)) {
                defeated.add(id);
                SBOEvent.INSTANCE.emit(new DianaMobDeathEvent((String)name, entity));
            }
            return new OverlayTextLine((String)name, false, false, 6, null);
        }
        return null;
    }

    private final boolean checkCocoon(class_1531 entity) {
        boolean lastInq;
        String cocoonTexture = "eyJ0aW1lc3RhbXAiOjE1ODMxMjMyODkwNTMsInByb2ZpbGVJZCI6IjkxZjA0ZmU5MGYzNjQzYjU4ZjIwZTMzNzVmODZkMzllIiwicHJvZmlsZU5hbWUiOiJTdG9ybVN0b3JteSIsInNpZ25hdHVyZVJlcXVpcmVkIjp0cnVlLCJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNlYjBlZDhmYzIyNzJiM2QzZDgyMDY3NmQ1MmEzOGU3YjJlOGRhOGM2ODdhMjMzZTBkYWJhYTE2YzBlOTZkZiJ9fX0=";
        boolean bl = lastInq = Helper.INSTANCE.getSecondsPassed(Helper.INSTANCE.getLastInqDeath()) < 5L;
        if (!lastInq) {
            return false;
        }
        class_1799 class_17992 = entity.method_6118(class_1304.field_6169);
        Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getEquippedStack(...)");
        class_1799 head = class_17992;
        if (!head.method_7960() && Intrinsics.areEqual((Object)head.method_7909().toString(), (Object)"minecraft:player_head")) {
            String texture;
            Property textures;
            class_9296 profile = (class_9296)head.method_58694(class_9334.field_49617);
            Object object = profile;
            Property property = textures = object != null && (object = object.comp_2412()) != null && (object = object.get((Object)"textures")) != null ? (Property)CollectionsKt.first((Iterable)((Iterable)object)) : null;
            String string = texture = property != null ? property.value() : null;
            if (StringsKt.equals$default((String)texture, (String)cocoonTexture, (boolean)false, (int)2, null) && Helper.INSTANCE.getLastCocoon() + (long)10000 < System.currentTimeMillis()) {
                Helper.INSTANCE.setLastCocoon(System.currentTimeMillis());
                if (Diana.INSTANCE.getAnnounceCocoon()) {
                    Helper.INSTANCE.sleep(200L, (Function0<Unit>)((Function0)DianaMobDetect::checkCocoon$lambda$2));
                }
                if (Diana.INSTANCE.getCocoonTitle()) {
                    Helper.INSTANCE.showTitle("\u00a7r\u00a76\u00a7l<\u00a7b\u00a7l\u00a7kO\u00a76\u00a7l> \u00a7b\u00a7lCOCOON! \u00a76\u00a7l<\u00a7b\u00a7l\u00a7kO\u00a76\u00a7l>", null, 10, 40, 10);
                    SoundHandler.playCustomSound$default(SoundHandler.INSTANCE, Customization.INSTANCE.getInqSound()[0], Customization.INSTANCE.getInqVolume(), 0.0f, 4, null);
                }
                return true;
            }
        }
        return false;
    }

    public final void onInqSpawn() {
        block2: {
            if (Diana.INSTANCE.getShareInq()) {
                SboVec playerPos = Player.INSTANCE.getLastPosition();
                Chat.INSTANCE.command("pc x: " + MathKt.roundToInt((double)playerPos.getX()) + ", y: " + (MathKt.roundToInt((double)playerPos.getY()) - 1) + ", z: " + MathKt.roundToInt((double)playerPos.getZ()));
            }
            String string = (String)ArraysKt.firstOrNull((Object[])Diana.INSTANCE.getAnnounceKilltext());
            if (string == null) break block2;
            String killText = string;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)killText)) {
                Helper.INSTANCE.sleep(5000L, (Function0<Unit>)((Function0)DianaMobDetect::onInqSpawn$lambda$4$lambda$3));
            }
        }
    }

    private static final boolean mobHpOverlay$lambda$0() {
        return Diana.INSTANCE.getMythosMobHp();
    }

    private static final Unit init$lambda$1(Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        class_638 class_6382 = SBOKotlin.mc.field_1687;
        if (class_6382 == null) {
            return Unit.INSTANCE;
        }
        class_638 world = class_6382;
        List overlayLines = new ArrayList();
        Iterator<Map.Entry<Integer, class_1531>> iterator = tracked.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, class_1531> entry = iterator.next();
            int id = ((Number)entry.getKey()).intValue();
            class_1531 armorStand = entry.getValue();
            if (!armorStand.method_5805() || !Intrinsics.areEqual((Object)armorStand.method_37908(), (Object)world)) {
                iterator.remove();
                defeated.remove(id);
                continue;
            }
            INSTANCE.checkCocoon(armorStand);
            OverlayTextLine line = INSTANCE.checkDianaMob(armorStand, id);
            if (line == null) continue;
            overlayLines.add(line);
        }
        mobHpOverlay.setLines(overlayLines);
        return Unit.INSTANCE;
    }

    private static final Unit checkCocoon$lambda$2() {
        Chat.INSTANCE.command("pc Cocoon!");
        return Unit.INSTANCE;
    }

    private static final Unit onInqSpawn$lambda$4$lambda$3() {
        Chat.INSTANCE.command("pc " + Diana.INSTANCE.getAnnounceKilltext()[0]);
        return Unit.INSTANCE;
    }
}

