/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.math;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\t\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0011J\r\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0013J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0013J\r\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b#\u0010\"J\u0010\u0010$\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b$\u0010\"J\u0010\u0010%\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b%\u0010\"J.\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b&\u0010'J\u001a\u0010)\u001a\u00020(2\b\u0010\b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b)\u0010*J\u0010\u0010,\u001a\u00020+H\u00d6\u0001\u00a2\u0006\u0004\b,\u0010-J\u0010\u0010.\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b.\u0010\u001dR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010/\u001a\u0004\b0\u0010\"\"\u0004\b1\u00102R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010/\u001a\u0004\b3\u0010\"\"\u0004\b4\u00102R\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010/\u001a\u0004\b5\u0010\"\"\u0004\b6\u00102\u00a8\u00068"}, d2={"Lnet/sbo/mod/utils/math/SboVec;", "", "", "x", "y", "z", "<init>", "(DDD)V", "other", "distanceTo", "(Lnet/sbo/mod/utils/math/SboVec;)D", "(DDD)D", "plus", "(Lnet/sbo/mod/utils/math/SboVec;)Lnet/sbo/mod/utils/math/SboVec;", "minus", "d", "times", "(D)Lnet/sbo/mod/utils/math/SboVec;", "clone", "()Lnet/sbo/mod/utils/math/SboVec;", "amount", "down", "roundLocationToBlock", "Lnet/minecraft/class_243;", "toVec3d", "()Lnet/minecraft/class_243;", "center", "", "toCleanString", "()Ljava/lang/String;", "", "toDoubleArray", "()[D", "length", "()D", "component1", "component2", "component3", "copy", "(DDD)Lnet/sbo/mod/utils/math/SboVec;", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "D", "getX", "setX", "(D)V", "getY", "setY", "getZ", "setZ", "Companion", "SBO"})
public final class SboVec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double x;
    private double y;
    private double z;

    public SboVec(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final double getX() {
        return this.x;
    }

    public final void setX(double d) {
        this.x = d;
    }

    public final double getY() {
        return this.y;
    }

    public final void setY(double d) {
        this.y = d;
    }

    public final double getZ() {
        return this.z;
    }

    public final void setZ(double d) {
        this.z = d;
    }

    public final double distanceTo(@NotNull SboVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Math.sqrt(Math.pow(other.x - this.x, 2) + Math.pow(other.y - this.y, 2) + Math.pow(other.z - this.z, 2));
    }

    public final double distanceTo(double x, double y, double z) {
        return Math.sqrt(Math.pow(x - this.x, 2) + Math.pow(y - this.y, 2) + Math.pow(z - this.z, 2));
    }

    @NotNull
    public final SboVec plus(@NotNull SboVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SboVec(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    @NotNull
    public final SboVec minus(@NotNull SboVec other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new SboVec(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    @NotNull
    public final SboVec times(double d) {
        return new SboVec(this.x * d, this.y * d, this.z * d);
    }

    @NotNull
    public final SboVec clone() {
        return SboVec.copy$default(this, 0.0, 0.0, 0.0, 7, null);
    }

    @NotNull
    public final SboVec down(double amount) {
        return SboVec.copy$default(this, 0.0, this.y - amount, 0.0, 5, null);
    }

    @NotNull
    public final SboVec roundLocationToBlock() {
        return new SboVec(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    @NotNull
    public final class_243 toVec3d() {
        return new class_243(this.x, this.y, this.z);
    }

    @NotNull
    public final SboVec center() {
        return new SboVec(this.x + 0.5, this.y + 0.5, this.z + 0.5);
    }

    @NotNull
    public final String toCleanString() {
        String string = "%.2f, %.2f, %.2f";
        Object[] objectArray = new Object[]{this.x, this.y, this.z};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final double[] toDoubleArray() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final SboVec copy(double x, double y, double z) {
        return new SboVec(x, y, z);
    }

    public static /* synthetic */ SboVec copy$default(SboVec sboVec, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = sboVec.x;
        }
        if ((n & 2) != 0) {
            d2 = sboVec.y;
        }
        if ((n & 4) != 0) {
            d3 = sboVec.z;
        }
        return sboVec.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "SboVec(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SboVec)) {
            return false;
        }
        SboVec sboVec = (SboVec)other;
        if (Double.compare(this.x, sboVec.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, sboVec.y) != 0) {
            return false;
        }
        return Double.compare(this.z, sboVec.z) == 0;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lnet/sbo/mod/utils/math/SboVec$Companion;", "", "<init>", "()V", "", "", "arr", "Lnet/sbo/mod/utils/math/SboVec;", "fromArray", "(Ljava/util/List;)Lnet/sbo/mod/utils/math/SboVec;", "SBO"})
    @SourceDebugExtension(value={"SMAP\nSboVec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SboVec.kt\nnet/sbo/mod/utils/math/SboVec$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SboVec fromArray(@NotNull List<Double> arr) {
            Intrinsics.checkNotNullParameter(arr, (String)"arr");
            if (!(arr.size() >= 3)) {
                boolean bl = false;
                String string = "Array must contain at least 3 elements for x, y, z.";
                throw new IllegalArgumentException(string.toString());
            }
            return new SboVec(((Number)arr.get(0)).doubleValue(), ((Number)arr.get(1)).doubleValue(), ((Number)arr.get(2)).doubleValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

