/*
 * Decompiled with CFR 0.152.
 */
package net.sbo.mod.utils.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\bR#\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0011\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lnet/sbo/mod/utils/math/Matrix;", "", "", "", "data", "<init>", "(Ljava/util/List;)V", "transpose", "()Lnet/sbo/mod/utils/math/Matrix;", "other", "multiply", "(Lnet/sbo/mod/utils/math/Matrix;)Lnet/sbo/mod/utils/math/Matrix;", "inverse", "Ljava/util/List;", "getData", "()Ljava/util/List;", "", "rows", "I", "getRows", "()I", "cols", "getCols", "sbo"})
@SourceDebugExtension(value={"SMAP\nMatrix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix.kt\nnet/sbo/mod/utils/math/Matrix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1#2:92\n*E\n"})
public final class Matrix {
    @NotNull
    private final List<List<Double>> data;
    private final int rows;
    private final int cols;

    public Matrix(@NotNull List<? extends List<Double>> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
        this.rows = this.data.size();
        this.cols = !((Collection)this.data).isEmpty() ? this.data.get(0).size() : 0;
    }

    @NotNull
    public final List<List<Double>> getData() {
        return this.data;
    }

    public final int getRows() {
        return this.rows;
    }

    public final int getCols() {
        return this.cols;
    }

    @NotNull
    public final Matrix transpose() {
        int n;
        int n2 = this.cols;
        ArrayList<List> arrayList = new ArrayList<List>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = n = i;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            int n4 = this.rows;
            ArrayList<Double> arrayList3 = new ArrayList<Double>(n4);
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                int n7 = n6 = n5++;
                ArrayList<Double> arrayList4 = arrayList3;
                boolean bl2 = false;
                arrayList4.add(0.0);
            }
            arrayList2.add(arrayList3);
        }
        List result = arrayList;
        int n8 = this.cols;
        for (int j = 0; j < n8; ++j) {
            n = this.rows;
            for (int i = 0; i < n; ++i) {
                ((List)result.get(j)).set(i, this.data.get(i).get(j));
            }
        }
        return new Matrix(result);
    }

    @NotNull
    public final Matrix multiply(@NotNull Matrix other) {
        int n;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.cols != other.rows) {
            throw new IllegalArgumentException("Matrix dimensions do not match for multiplication");
        }
        int n2 = this.rows;
        ArrayList<List> arrayList = new ArrayList<List>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = n = i;
            ArrayList<List> arrayList2 = arrayList;
            boolean bl = false;
            int n4 = other.cols;
            ArrayList<Double> arrayList3 = new ArrayList<Double>(n4);
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                int n7 = n6 = n5++;
                ArrayList<Double> arrayList4 = arrayList3;
                boolean bl2 = false;
                arrayList4.add(0.0);
            }
            arrayList2.add(arrayList3);
        }
        List result = arrayList;
        int n8 = this.rows;
        for (int i = 0; i < n8; ++i) {
            n = other.cols;
            for (int j = 0; j < n; ++j) {
                double sum = 0.0;
                int n9 = this.cols;
                for (int k = 0; k < n9; ++k) {
                    sum += ((Number)this.data.get(i).get(k)).doubleValue() * ((Number)other.data.get(k).get(j)).doubleValue();
                }
                ((List)result.get(i)).set(j, sum);
            }
        }
        return new Matrix(result);
    }

    @NotNull
    public final Matrix inverse() {
        Object object;
        int n;
        int n2;
        int i;
        if (this.rows != this.cols) {
            throw new IllegalArgumentException("Only square matrices can be inverted");
        }
        int n3 = this.rows;
        int n4 = 0;
        double[][] dArrayArray = new double[n3][];
        while (n4 < n3) {
            int n5 = n4++;
            dArrayArray[n5] = new double[2 * n3];
        }
        double[][] augmented = dArrayArray;
        for (i = 0; i < n3; ++i) {
            int j;
            for (j = 0; j < n3; ++j) {
                augmented[i][j] = ((Number)this.data.get(i).get(j)).doubleValue();
            }
            for (j = 0; j < n3; ++j) {
                augmented[i][j + n3] = i == j ? 1.0 : 0.0;
            }
        }
        for (i = 0; i < n3; ++i) {
            int maxRow = i;
            for (int k = i + 1; k < n3; ++k) {
                if (!(Math.abs(augmented[k][i]) > Math.abs(augmented[maxRow][i]))) continue;
                maxRow = k;
            }
            double[] temp = augmented[i];
            augmented[i] = augmented[maxRow];
            augmented[maxRow] = temp;
            if (Math.abs(augmented[i][i]) < 1.0E-12) {
                throw new IllegalArgumentException("Matrix is singular and cannot be inverted");
            }
            double pivot = augmented[i][i];
            int j = 0;
            int n6 = 2 * n3;
            while (j < n6) {
                double[] dArray = augmented[i];
                n2 = j++;
                dArray[n2] = dArray[n2] / pivot;
            }
            for (int k = 0; k < n3; ++k) {
                if (k == i) continue;
                double factor = augmented[k][i];
                n = 2 * n3;
                for (int j2 = 0; j2 < n; ++j2) {
                    object = augmented[k];
                    int n7 = j2;
                    object[n7] = object[n7] - factor * augmented[i][j2];
                }
            }
        }
        ArrayList<List> maxRow = new ArrayList<List>(n3);
        for (int temp = 0; temp < n3; ++temp) {
            int n8;
            int n9 = n8 = temp;
            ArrayList<List> arrayList = maxRow;
            boolean bl = false;
            ArrayList<Double> arrayList2 = new ArrayList<Double>(n3);
            int n10 = 0;
            while (n10 < n3) {
                n = n2 = n10++;
                object = arrayList2;
                boolean bl2 = false;
                ((ArrayList)object).add(0.0);
            }
            arrayList.add(arrayList2);
        }
        List inv = maxRow;
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int j = 0; j < n3; ++j) {
                ((List)inv.get(i2)).set(j, augmented[i2][j + n3]);
            }
        }
        return new Matrix(inv);
    }
}

